<?php 
include('header.php');
?>
<!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <div class="card radius-10">
           <div class="main-content">
                <section class="section">
                    <div class="card-header bg-dark">
                        <div class="card-title">
                            <h3 style="color:white"><strong>इलेक्ट्रोल सूची <sup style="color:red"><B>HD</B></sup></strong></h3>
                        </div>
                    </div>
                    <hr>
                    <div class="card-content collapse show">
                        <div class="card-body card-dashboard table-responsive">
                            <input type="text" id="searchInput" placeholder="यहाँ खोजें..." class="form-control mb-3" onkeyup="filterTable()">
                            <table id="electoralList" class="table table-striped table-bordered zero-configuration" style="font-size:12px;">
                                <thead>
                                    <tr style="background:linear-gradient(-62deg, #3a3a53, #03a9f4) !important;">
                                        <th style="color:#fff">Sn.No.</th>
                                        <th style="color:#fff">आवेदक का नाम</th>
                                        <th style="color:#fff">आवेदन संख्या</th>
                                        <th style="color:#fff">मोबाइल नंबर</th> <!-- आय का स्रोत को मोबाइल नंबर में बदला -->
                                        <th style="color:#fff">तारीख और समय</th>
                                        <th style="color:#fff">स्थिति</th>
                                        <th style="color:#fff">PDF डाउनलोड</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    if($udata['type']=='admin') {
                                        $sql = "SELECT * FROM `electoral_roll_applications` ORDER BY id DESC";
                                    } else {
                                        $sql = "SELECT * FROM `electoral_roll_applications` WHERE applied_by='" . $udata['phone'] . "' ORDER BY id DESC";
                                    }

                                    $result = mysqli_query($ahk_conn, $sql);
                                    $x = 0; 
                                    while ($row = mysqli_fetch_array($result)) {
                                        $x++; 
                                        $date = date_create($row['date']); 
                                        ?>
                                        <tr>
                                            <td><?=$x?></td>
                                            <td><?=$row['applicant_name']?></td>
                                            <td><?=$row['registration_number']?></td>
                                            <td><?=$row['mobile_number']?></td>
                                            <td><?=date_format($date, 'j M Y g:ia')?></td>
                                            <td><?=$row['status']?></td>
                                            <td align="center">
                                                <?php if(!empty($row['admin_file'])) { ?>
                                                    <a class="btn btn-primary" href="uploads/<?= htmlspecialchars($row['admin_file']) ?>" target="_blank" download>
                                                        <i class="fa fa-download"></i> फाइल डाउनलोड
                                                    </a>
                                                <?php } else { ?>
                                                    <span class="badge bg-warning">कोई फाइल अपलोड नहीं की गई</span>
                                                <?php } ?>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </section>
            </div>
        </div>
    </div>
</div>
<!--end page wrapper -->
<?php 
include('footer.php');
?>
<!-- Bootstrap JS -->
<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
<!--plugins-->
<script src="../template/ahkweb/assets/js/jquery.min.js"></script>
<script src="../template/ahkweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/ahkweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/ahkweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/ahkweb/assets/plugins/chartjs/chart.min.js"></script>
<script src="../template/ahkweb/assets/plugins/vectormap/jquery-jvectormap-2.0.2.min.js"></script>
<script src="../template/ahkweb/assets/plugins/vectormap/jquery-jvectormap-world-mill-en.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery.easy-pie-chart/jquery.easypiechart.min.js"></script>
<script src="../template/ahkweb/assets/plugins/sparkline-charts/jquery.sparkline.min.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery-knob/excanvas.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery-knob/jquery.knob.js"></script>
<script>
$(function() {
    $(".knob").knob();
});

function filterTable() {
    var input, filter, table, tr, td, i, j, txtValue;
    input = document.getElementById("searchInput");
    filter = input.value.toUpperCase();
    table = document.getElementById("electoralList");
    tr = table.getElementsByTagName("tr");

    for (i = 1; i < tr.length; i++) { // Start from 1 to skip the header row
        tr[i].style.display = "none"; // Initially hide all rows
        td = tr[i].getElementsByTagName("td");
        for (j = 0; j < td.length; j++) {
            if (td[j]) {
                txtValue = td[j].textContent || td[j].innerText;
                if (txtValue.toUpperCase().indexOf(filter) > -1) {
                    tr[i].style.display = ""; // Show the row
                    break; // Stop searching in other columns
                }
            }
        }
    }
}
</script>
<script src="../template/ahkweb/assets/js/index.js"></script>
<!--app JS-->
<script src="../template/ahkweb/assets/js/app.js"></script>
<!-- datatable -->
<script src="../template/ahkweb/assets/plugins/datatable/js/jquery.dataTables.min.js"></script>
<script src="../template/ahkweb/assets/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>
<script>
    $(document).ready(function() {
        $('#electoralList').DataTable();
    });
</script>

</body>
</html>
