<?php
include('header.php');

// Initialize error and success messages
$error_message = '';
$success_message = '';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Retrieve and sanitize form data
    $applicant_name = mysqli_real_escape_string($ahk_conn, $_POST['applicant_name']);
    $gender = mysqli_real_escape_string($ahk_conn, $_POST['gender']);
    $mobile_number = mysqli_real_escape_string($ahk_conn, $_POST['mobile_number']);
    $dob = mysqli_real_escape_string($ahk_conn, $_POST['dob']);
    $father_name = mysqli_real_escape_string($ahk_conn, $_POST['father_name']);
    $aadhar_number = mysqli_real_escape_string($ahk_conn, $_POST['aadhar_number']);
    $pan_number = mysqli_real_escape_string($ahk_conn, $_POST['pan_number']);
    $email_id = mysqli_real_escape_string($ahk_conn, $_POST['email_id']);
    $state = mysqli_real_escape_string($ahk_conn, $_POST['state']);
    $district = mysqli_real_escape_string($ahk_conn, $_POST['district']);
    $sub_division = mysqli_real_escape_string($ahk_conn, $_POST['sub_division']);
    $circle_office = mysqli_real_escape_string($ahk_conn, $_POST['circle_office']);
    $house_no = mysqli_real_escape_string($ahk_conn, $_POST['house_no']);
    $mouza = mysqli_real_escape_string($ahk_conn, $_POST['mouza']);
    $village_town = mysqli_real_escape_string($ahk_conn, $_POST['village_town']);
    $police_station = mysqli_real_escape_string($ahk_conn, $_POST['police_station']);
    $post_office = mysqli_real_escape_string($ahk_conn, $_POST['post_office']);
    $pin_code = mysqli_real_escape_string($ahk_conn, $_POST['pin_code']);
    $lac_name = mysqli_real_escape_string($ahk_conn, $_POST['lac_name']);
    $lac_no = mysqli_real_escape_string($ahk_conn, $_POST['lac_no']);
    $polling_station_name = mysqli_real_escape_string($ahk_conn, $_POST['polling_station_name']);
    $polling_station_no = mysqli_real_escape_string($ahk_conn, $_POST['polling_station_no']);
    $part_number = mysqli_real_escape_string($ahk_conn, $_POST['part_number']);
    $gp_or_ward = mysqli_real_escape_string($ahk_conn, $_POST['gp_or_ward']);
    $year_of_electoral_roll = mysqli_real_escape_string($ahk_conn, $_POST['year_of_electoral_roll']);

    // New fields
    $application_fee = 100; // Set fee to 100
    $appliedby = $udata['phone']; // Assuming user phone number from session
    $application_no = "LS" . rand(10000000, 99999999); // Generate unique application number
    $date = date("Y-m-d H:i:s"); // Get current date and time

    // Supporting documents upload
    $uploads_dir = "uploads/"; // Set the uploads directory
    $voter_id_card = $_FILES['voter_id_card']['name'];
    $voter_id_card_tmp = $_FILES['voter_id_card']['tmp_name'];
    $voter_id_card_error = $_FILES['voter_id_card']['error'];
    $voter_id_card_type = pathinfo($voter_id_card, PATHINFO_EXTENSION);

    // Validate file type (example: only allow JPG, PNG, PDF)
    $allowed_types = ['jpg', 'jpeg', 'png', 'pdf'];
    if ($voter_id_card_error == UPLOAD_ERR_OK) {
        if (in_array($voter_id_card_type, $allowed_types)) {
            move_uploaded_file($voter_id_card_tmp, $uploads_dir . $voter_id_card);
        } else {
            $error_message = "Invalid file type for Voter ID Card. Allowed types: " . implode(", ", $allowed_types);
        }
    } else {
        $error_message = "Error uploading Voter ID Card: " . $voter_id_card_error;
    }

    // Check if user balance is sufficient
    if (empty($error_message) && $udata['balance'] >= $application_fee) {
        $nbal = $udata['balance'] - $application_fee;

        // Update user balance
        $debit_query = "UPDATE users SET balance=$nbal WHERE phone='$appliedby'";
        if (mysqli_query($ahk_conn, $debit_query)) {
            // Insert the application details into the database
            $query = "INSERT INTO electoral_roll_applications 
                        (applicant_name, gender, mobile_number, dob, father_name, aadhar_number, 
                        pan_number, email_id, state, district, sub_division, circle_office, 
                        house_no, mouza, village_town, police_station, post_office, 
                        pin_code, lac_name, lac_no, polling_station_name, polling_station_no, 
                        part_number, gp_or_ward, year_of_electoral_roll, voter_id_card, 
                        registration_number, applied_by, balance_deducted) 
                      VALUES 
                        ('$applicant_name', '$gender', '$mobile_number', '$dob', '$father_name', 
                        '$aadhar_number', '$pan_number', '$email_id', '$state', '$district', 
                        '$sub_division', '$circle_office', '$house_no', '$mouza', '$village_town', 
                        '$police_station', '$post_office', '$pin_code', '$lac_name', '$lac_no', 
                        '$polling_station_name', '$polling_station_no', '$part_number', 
                        '$gp_or_ward', '$year_of_electoral_roll', '$voter_id_card', 
                        '$application_no', '$appliedby', '$application_fee')"; // Added application number and fee deduction

            if (mysqli_query($ahk_conn, $query)) {
                $success_message = "Application for Certified Copy of Electoral Roll submitted successfully.";
                echo "<script>
                        Swal.fire({
                            icon: 'success',
                            title: 'Application Submitted Successfully!',
                            text: 'Your application has been submitted successfully.',
                            confirmButtonText: 'OK'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                window.location.href = 'voterassam.php'; // Redirect to a thank-you page
                            }
                        });
                      </script>";
            } else {
                $error_message = "Error inserting application: " . mysqli_error($ahk_conn);
            }
        } else {
            $error_message = "Error updating user balance: " . mysqli_error($ahk_conn);
        }
    } else if (empty($error_message)) {
        $error_message = "Insufficient balance to pay the application fee.";
    }
}
?>

<!-- Display success or error message -->
<?php if (!empty($success_message)) : ?>
    <div class="alert alert-success"><?= $success_message; ?></div>
<?php endif; ?>

<?php if (!empty($error_message)) : ?>
    <div class="alert alert-danger"><?= $error_message; ?></div>
<?php endif; ?>



<!-- Start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <div class="row">
            <div class="col-xl-10 mx-auto">
                <h6 class="mb-0 text-uppercase">Application for Certified Copy of Electoral Roll</h6>
                <hr />
                <div class="card border-top border-0 border-4 border-primary">
                    <div class="card-body p-5">
                        <form action="" method="POST" class="row g-3" enctype="multipart/form-data">

                            <!-- Applicant's Details -->
                            <h5 class="text-primary">Applicant's Details (আবেদনকাৰীৰ বেৱৰণ)</h5>
                            <div class="col-md-6">
                                <label for="applicant_name" class="form-label">*Applicant’s Name (আববদনকোৰীৰ নোম)</label>
                                <input name="applicant_name" type="text" placeholder="Applicant’s Name" class="form-control" id="applicant_name" required>
                            </div>
                            <div class="col-md-6">
                                <label for="gender" class="form-label">*Applicant’s Gender (       ৰ ৰ    )</label>
                                <select name="gender" class="form-select" id="gender" required>
                                    <option value="">Select Gender</option>
                                    <option value="Male">Male</option>
                                    <option value="Female">Female</option>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label for="mobile_number" class="form-label">*Mobile Number (মবোইল নম্বৰ)</label>
                                <input name="mobile_number" type="text" placeholder="Mobile Number" class="form-control" id="mobile_number" required>
                            </div>
                            <div class="col-md-6">
                                <label for="dob" class="form-label">*Date of Birth (   ৰ    ৰ )</label>
                                <input name="dob" type="date" class="form-control" id="dob" required>
                            </div>
                            <div class="col-md-6">
                                <label for="father_name" class="form-label">*Father’s Name (   ৰ    )</label>
                                <input name="father_name" type="text" placeholder="Father's Name" class="form-control" id="father_name" required>
                            </div>
                            <div class="col-md-6">
                                <label for="aadhar_number" class="form-label">*Aadhar Number (আধাৰ নম্বৰ)</label>
                                <input name="aadhar_number" type="text" placeholder="Aadhar Number" class="form-control" id="aadhar_number" required>
                            </div>
                            <div class="col-md-6">
                                <label for="pan_number" class="form-label">*PAN Number (পএএন নম্বৰ)</label>
                                <input name="pan_number" type="text" placeholder="PAN Number" class="form-control" id="pan_number" required>
                            </div>
                            <div class="col-md-6">
                                <label for="email_id" class="form-label">Email ID (ইমেইল আইডি)</label>
                                <input name="email_id" type="email" placeholder="Email ID" class="form-control" id="email_id">
                            </div>
                            
                            <!-- Address Details -->
                            <h5 class="text-primary mt-4">Address Details (ঠিকনা বিৱৰণ)</h5>
                            <div class="col-md-6">
                                <label for="state" class="form-label">*State (ৰাজ্য)</label>
                                <input name="state" type="text" placeholder="State" class="form-control" id="state" required>
                            </div>
                            <div class="col-md-6">
                                <label for="district" class="form-label">*District (জিলা)</label>
                                <input name="district" type="text" placeholder="District" class="form-control" id="district" required>
                            </div>
                            <div class="col-md-6">
                                <label for="sub_division" class="form-label">Sub-Division (উপবিভাগ)</label>
                                <input name="sub_division" type="text" placeholder="Sub-Division" class="form-control" id="sub_division">
                            </div>
                            <div class="col-md-6">
                                <label for="circle_office" class="form-label">Circle Office (চক্ৰ দফতৰ)</label>
                                <input name="circle_office" type="text" placeholder="Circle Office" class="form-control" id="circle_office">
                            </div>
                            <div class="col-md-6">
                                <label for="house_no" class="form-label">House No (ঘৰ নম্বৰ)</label>
                                <input name="house_no" type="text" placeholder="House No" class="form-control" id="house_no">
                            </div>
                            <div class="col-md-6">
                                <label for="mouza" class="form-label">Mouza (মৌজা)</label>
                                <input name="mouza" type="text" placeholder="Mouza" class="form-control" id="mouza">
                            </div>
                            <div class="col-md-6">
                                <label for="village_town" class="form-label">*Village/Town (গ্ৰাম/চহৰ)</label>
                                <input name="village_town" type="text" placeholder="Village/Town" class="form-control" id="village_town" required>
                            </div>
                            <div class="col-md-6">
                                <label for="police_station" class="form-label">Police Station (পুলিশ থান)</label>
                                <input name="police_station" type="text" placeholder="Police Station" class="form-control" id="police_station">
                            </div>
                            <div class="col-md-6">
                                <label for="post_office" class="form-label">Post Office (পোস্ট দফতৰ)</label>
                                <input name="post_office" type="text" placeholder="Post Office" class="form-control" id="post_office">
                            </div>
                            <div class="col-md-6">
                                <label for="pin_code" class="form-label">Pin Code (পিন নম্বৰ)</label>
                                <input name="pin_code" type="text" placeholder="Pin Code" class="form-control" id="pin_code">
                            </div>

                            <!-- Electoral Roll Details -->
                            <h5 class="text-primary mt-4">Electoral Roll Details (ভোটাৰ তালিকা বিৱৰণ)</h5>
                            <div class="col-md-6">
                                <label for="lac_name" class="form-label">*LAC Name (এলএছৰ নাম)</label>
                                <input name="lac_name" type="text" placeholder="LAC Name" class="form-control" id="lac_name" required>
                            </div>
                            <div class="col-md-6">
                                <label for="lac_no" class="form-label">*LAC No (এলএছৰ নম্বৰ)</label>
                                <input name="lac_no" type="text" placeholder="LAC No" class="form-control" id="lac_no" required>
                            </div>
                            <div class="col-md-6">
                                <label for="polling_station_name" class="form-label">*Polling Station Name (ভোটার কেন্দ্ৰৰ নাম)</label>
                                <input name="polling_station_name" type="text" placeholder="Polling Station Name" class="form-control" id="polling_station_name" required>
                            </div>
                            <div class="col-md-6">
                                <label for="polling_station_no" class="form-label">*Polling Station No (ভোটাৰ কেন্দ্ৰৰ নম্বৰ)</label>
                                <input name="polling_station_no" type="text" placeholder="Polling Station No" class="form-control" id="polling_station_no" required>
                            </div>
                            <div class="col-md-6">
                                <label for="part_number" class="form-label">Part Number (অংশ নম্বৰ)</label>
                                <input name="part_number" type="text" placeholder="Part Number" class="form-control" id="part_number">
                            </div>
                            <div class="col-md-6">
                                <label for="gp_or_ward" class="form-label">*GP/Ward (গ্ৰাম পঞ্চায়ত/ৱাৰ্ড)</label>
                                <input name="gp_or_ward" type="text" placeholder="GP/Ward" class="form-control" id="gp_or_ward" required>
                            </div>
                            <div class="col-md-6">
                                <label for="year_of_electoral_roll" class="form-label">*Year of Electoral Roll (ভোটাৰ তালিকা বৰ্ষ)</label>
                                <input name="year_of_electoral_roll" type="text" placeholder="Year of Electoral Roll" class="form-control" id="year_of_electoral_roll" required>
                            </div>

                            <!-- Upload Documents -->
                            <div class="col-md-6">
                                <label for="voter_id_card" class="form-label">*Voter ID Card (ভোটাৰ আইডি কাৰ্ড)</label>
                                <input name="voter_id_card" type="file" class="form-control" id="voter_id_card" accept=".jpg,.jpeg,.png,.pdf" required>
                            </div>

                            <div class="col-md-12 text-center">
                                <button type="submit" class="btn btn-primary">Submit Application</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include('footer.php'); ?>
