<?php
// Include session and database configuration
include('header.php');

// Fetch current user details
$current_user = mysqli_query($ahk_conn, "SELECT * FROM users WHERE phone='".$udata['phone']."'");
$user_data = mysqli_fetch_assoc($current_user);

// Get current role and balance
$current_role = $user_data['type'];
$current_balance = $user_data['balance'];

// Upgrade options based on current role
$upgrade_options = [
    "retailer" => ["new_role" => "distributor", "cost" => 199],
    "distributor" => ["new_role" => "super_dist", "cost" => 299],
    "retailer_to_super_dist" => ["new_role" => "super_dist", "cost" => 499], // Direct upgrade from retailer to super distributor
];

// Check if the current role has an upgrade option
$upgrade_message = '';
if (isset($upgrade_options[$current_role])) {
    $next_role = $upgrade_options[$current_role]['new_role'];
    $upgrade_cost = $upgrade_options[$current_role]['cost'];

    // Check if user has enough balance for the upgrade
    if ($current_balance >= $upgrade_cost) {
        $upgrade_message = "<h3>Your current role is {$current_role}. Choose an upgrade option:</h3>
                            <form method='post'>
                                <input type='hidden' name='upgrade_role' value='distributor'>
                                <button type='submit' name='upgrade' class='btn-upgrade'>Upgrade to Distributor (₹{$upgrade_options['retailer']['cost']})</button>
                            </form>
                            <form method='post'>
                                <input type='hidden' name='upgrade_role' value='super_dist'>
                                <button type='submit' name='upgrade' class='btn-upgrade'>Upgrade to Super Distributor (₹{$upgrade_options['retailer_to_super_dist']['cost']})</button>
                            </form>";
    } else {
        $upgrade_message = "<h3>Your balance is insufficient. You need at least ₹{$upgrade_cost} to upgrade.</h3>";
    }
} else {
    $upgrade_message = "<h3>You are already at the highest role or there are no further upgrades available.</h3>";
}

// Process the upgrade request
if (isset($_POST['upgrade'])) {
    $new_role = $_POST['upgrade_role']; // New role (Distributor or Super Distributor)
    $deduct_amount = $upgrade_options[$new_role === 'super_dist' ? 'retailer_to_super_dist' : $current_role]['cost']; // Deduction amount for upgrade

    // Deduct balance
    $new_balance = $current_balance - $deduct_amount;

    // Update user's role and balance in the database
    $update_query = "UPDATE users SET balance='$new_balance', type='$new_role' WHERE phone='".$udata['phone']."'";
    $update_balance = mysqli_query($ahk_conn, $update_query);

    if ($update_balance) {
        // Show success message using SweetAlert
        echo "<script>
                Swal.fire({
                    title: 'Upgrade Successful!',
                    text: 'Your role has been successfully upgraded to {$new_role}.',
                    icon: 'success'
                });
                setTimeout(() => { window.location='index.php'; }, 1500);
              </script>";
    } else {
        // Show error message using SweetAlert
        echo "<script>
                Swal.fire({
                    title: 'Upgrade Failed!',
                    text: 'There was an issue upgrading your role. Please try again.',
                    icon: 'error'
                });
              </script>";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Upgrade</title>
    <!-- Include SweetAlert CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@10/dist/sweetalert2.min.css">
    <style>
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            background-image: url('https://via.placeholder.com/1920x1080'); /* Placeholder URL for background */
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
        }
        .container {
            max-width: 500px;
            width: 100%;
            background: rgba(255, 255, 255, 0.9); /* Semi-transparent background */
            padding: 30px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
            border-radius: 10px;
            text-align: center;
        }
        h3 {
            color: #333;
            margin-bottom: 20px;
            font-size: 24px;
        }
        .btn-upgrade {
            display: block;
            width: 100%;
            padding: 12px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 25px;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.3s ease;
            margin-bottom: 10px; /* Add some space between buttons */
        }
        .btn-upgrade:hover {
            background-color: #0056b3;
        }
        .btn-upgrade:focus {
            outline: none;
        }
        .upgrade-text {
            font-size: 16px;
            color: #555;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>

<div class="container">
    <h3>Upgrade Your Account</h3>
    <p class="upgrade-text">Choose the upgrade option that suits you.</p>
    <?php
    // Show the upgrade message and form
    echo $upgrade_message;
    ?>
</div>

<!-- Include SweetAlert JS Library -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>

</body>
</html>
