<?php 
include('header.php');
?>
<!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <div class="card radius-10">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div>
                        <h5 class="mb-0">All UCL Applications</h5>
                    </div>
                </div>
                <hr>
                <div class="table-responsive">
                    <table id="example2" class="table align-middle mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="text-center">SL.</th>
                                <th class="text-center">Applicant Name</th>
                                <th class="text-center">Application Number</th>
                                <th class="text-center">Mobile</th>
                                <th class="text-center">Email</th>
                                <th class="text-center">Address</th>
                                <th class="text-center">User Type</th>
                                <th class="text-center">Status</th>
                                <th class="text-center">Fee</th>
                                <th class="text-center">Date</th>
                            </tr>
                        </thead>
                        <tbody>

<?php
$res = mysqli_query($ahk_conn, "SELECT * FROM ucl_applications ORDER BY id DESC");
if(mysqli_num_rows($res) > 0){
    $x = 0;
    while($data = mysqli_fetch_assoc($res)){
        $x++;
        ?>
        <tr>
            <td class="text-center"><?= $x; ?></td>
            <td class="text-center"><?= strtoupper($data['applicant_name']); ?></td>
            <td class="text-center"><?= strtoupper($data['application_no']); ?></td>
            <td class="text-center"><?= strtoupper($data['mobile']); ?></td>
            <td class="text-center"><?= strtolower($data['gmail']); ?></td>
            <td class="text-center"><?= strtoupper($data['address']); ?></td>
            <td class="text-center"><?= ucfirst($data['user_type']); ?></td>
            <td class="text-center">
                <?php
                if($data['status'] == "pending"){
                    echo '<div class="badge bg-warning text-dark">Pending</div>';
                } else if($data['status'] == "approved"){
                    echo '<div class="badge bg-success text-white">Approved</div>';
                } else if($data['status'] == "rejected"){
                    echo '<div class="badge bg-danger text-white">Rejected</div>';
                }
                ?>
            </td>
            <td class="text-center"><?= number_format($data['fee'], 2); ?></td>
            <td class="text-center"><?= date('d-m-Y', strtotime($data['date'])); ?></td>
        </tr>
        <?php
    }
}
?>
                          
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</div>
<!--end page wrapper -->
<?php 
include('footer.php');
?>

<!-- Bootstrap JS -->
<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
<!--plugins-->
<script src="../template/ahkweb/assets/js/jquery.min.js"></script>
<script src="../template/ahkweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/ahkweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/ahkweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<!--app JS-->
<script src="../template/ahkweb/assets/js/app.js"></script>
<!-- datatable -->
<script src="../template/ahkweb/assets/plugins/datatable/js/jquery.dataTables.min.js"></script>
<script src="../template/ahkweb/assets/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>
<script>
$(document).ready(function() {
    $('#example2').DataTable({
        lengthChange: false,
        buttons: ['copy', 'excel', 'pdf', 'print']
    });
});
</script>
</body>
</html>
