<?php
include('header.php');

// Initialize error and success messages
$error_message = '';
$success_message = '';

// Check if form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Retrieve form data
    $applicant_name = mysqli_real_escape_string($ahk_conn, $_POST['applicant_name']);
    $mobile = mysqli_real_escape_string($ahk_conn, $_POST['mobile']);
    $gmail = mysqli_real_escape_string($ahk_conn, $_POST['gmail']);
    $address = mysqli_real_escape_string($ahk_conn, $_POST['address']);
    $user_type = mysqli_real_escape_string($ahk_conn, $_POST['user_type']);
    $fee = mysqli_real_escape_string($ahk_conn, $_POST['fee']);
    $appliedby = $udata['phone'];
    $application_no = "UCL" . rand(10000000, 99999999); // Generate a unique application number
    $date = date("Y-m-d H:i:s");

    // Check if user balance is sufficient
    if ($udata['balance'] >= $fee) {
        $nbal = $udata['balance'] - $fee;

        // Update user balance
        $debit = mysqli_query($ahk_conn, "UPDATE users SET balance=balance-$fee WHERE phone='$appliedby'");

        // Log transaction in history
        $updatehistory = mysqli_query($ahk_conn, "INSERT INTO `wallethistory`(`userid`, `amount`, `balance`, `purpose`, `status`, `type`) VALUES ('$appliedby','$fee','$nbal','UCL Application Fee','1','Debit')");

        if ($debit && $updatehistory) {
            // Insert user details into the database
            $submit = mysqli_query($ahk_conn, "INSERT INTO `ucl_applications` (`appliedby`, `application_no`, `applicant_name`, `mobile`, `gmail`, `address`, `user_type`, `status`, `fee`, `date`) VALUES ('$appliedby', '$application_no', '$applicant_name', '$mobile', '$gmail', '$address', '$user_type', 'pending', '$fee', '$date')");

            if ($submit) {
                $success_message = 'Application submitted successfully.';
            } else {
                $error_message = 'Failed to submit application. Please try again.';
            }
        } else {
            $error_message = 'Failed to update balance. Please try again.';
        }
    } else {
        $error_message = 'Insufficient balance. Please recharge your wallet.';
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <!-- Required meta tags and CSS -->
</head>
<body>
<!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">UCL Application</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">UCL Application Form</li>
                    </ol>
                </nav>
            </div>
        </div>
        <!--end breadcrumb-->
        
        <div class="row">
            <div class="col-xl-10 mx-auto">
                <div class="card border-top border-0 border-4 border-primary">
                    <div class="card-body p-5">
                        <div class="card-title d-flex align-items-center">
                            <div><i class="bx bx-user me-1 font-22 text-primary"></i></div>
                            <h5 class="mb-0 text-primary">UCL Application Form</h5>
                        </div>
                        <hr>

                        <!-- Display success or error message -->
                        <?php if ($success_message): ?>
                            <div class="alert alert-success" role="alert">
                                <?php echo $success_message; ?>
                            </div>
                        <?php endif; ?>
                        <?php if ($error_message): ?>
                            <div class="alert alert-danger" role="alert">
                                <?php echo $error_message; ?>
                            </div>
                        <?php endif; ?>

                        <form action="" method="POST" class="row g-3">
                            <!-- Applicant Name -->
                            <div class="col-md-6">
                                <label for="applicant_name" class="form-label">Applicant Name:</label>
                                <input type="text" id="applicant_name" name="applicant_name" class="form-control" required>
                            </div>

                            <!-- Mobile Number -->
                            <div class="col-md-6">
                                <label for="mobile" class="form-label">Mobile Number:</label>
                                <input type="text" id="mobile" name="mobile" class="form-control" data-inputmask="'mask': '9999999999'" placeholder="Enter 10-digit mobile number" required>
                                <small>Enter a valid 10-digit mobile number.</small>
                            </div>

                            <!-- Email -->
                            <div class="col-md-6">
                                <label for="gmail" class="form-label">Email:</label>
                                <input type="email" id="gmail" name="gmail" class="form-control" required>
                            </div>

                            <!-- Address -->
                            <div class="col-md-6">
                                <label for="address" class="form-label">Address:</label>
                                <textarea id="address" name="address" class="form-control" required></textarea>
                            </div>

                            <!-- User Type -->
                            <div class="col-md-6">
                                <label for="user_type" class="form-label">User Type:</label>
                                <select id="user_type" name="user_type" class="form-select" required>
                                    <option value="">Select User Type</option>
                                    <option value="Admin">Admin</option>
                                    <option value="User">User</option>
                                </select>
                            </div>

                            <!-- Fee Display -->
                            <div class="col-md-6">
                                <label for="fee" class="form-label">Fee (INR):</label>
                                <input type="text" id="fee" name="fee" class="form-control" readonly>
                            </div>

                            <!-- Submit Button -->
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary px-5">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!--end page wrapper -->

<?php 
include('footer.php');
?>

<!-- Bootstrap JS -->
<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
<script src="../template/ahkweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/ahkweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/ahkweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<!--app JS-->
<script src="../template/ahkweb/assets/js/app.js"></script>

<!-- Inputmask for number -->
<script>
    $(document).ready(function() {
        $('#mobile').inputmask(); // Masking the phone number input

        // Fee calculation based on User Type selection
        $('#user_type').change(function() {
            var userType = $(this).val();
            var fee = 0;

            if (userType === 'Admin') {
                fee = 500; // Example fee for Admin
            } else if (userType === 'User') {
                fee = 200; // Example fee for User
            }

            $('#fee').val(fee);
        });
    });
</script>

</body>
</html>
