<?php 
include('header.php');

// Check if the user is an admin
if (checkAdmin($udata['type']) == false) {
    echo '<script>window.location="../index.php";</script>';
    exit();
}

// Handle form submission to update status
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['status']) && isset($_POST['id']) && !empty($_POST['status']) && !empty($_POST['id'])) {
        $status = mysqli_real_escape_string($ahk_conn, $_POST['status']);
        $id = mysqli_real_escape_string($ahk_conn, $_POST['id']);
        
        // Update the status in the database
        $sql = mysqli_query($ahk_conn, "UPDATE ucl_applications SET status='$status' WHERE id='$id'");
        
        if ($sql) {
            echo '<script>
                    $(function() {
                        Swal.fire(
                            "Status Updated Successfully!",
                            "",
                            "success"
                        ).then(() => {
                            window.location = "ucladminlist.php"; // Redirect to the page with the updated list
                        });
                    });
                  </script>';
        } else {
            echo '<script>
                    $(function() {
                        Swal.fire(
                            "Error While Updating Status!",
                            "",
                            "error"
                        );
                    });
                  </script>';
        }
    }
}
?>
<!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <div class="card radius-10">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div>
                        <h5 class="mb-0">All UCL Applications Admin List</h5>
                    </div>
                </div>
                <hr>
                <div class="table-responsive">
                    <table id="example2" class="table align-middle mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="text-center">SL.</th>
                                <th class="text-center">Appliedby</th>
                                <th class="text-center">Apply Date</th>
                                <th class="text-center">Name</th>
                                <th class="text-center">MOBILE NO.</th>
                                <th class="text-center">GMAIL</th>
                                <th class="text-center">APPLICATION NUMBER</th>
                                <th class="text-center">ADDRESS</th>
                                <th class="text-center">Status</th>
                                <th class="text-center">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $res = mysqli_query($ahk_conn, "SELECT * FROM ucl_applications ORDER BY id DESC");
                            if (mysqli_num_rows($res) > 0) {
                                $x = 0;
                                while ($data = mysqli_fetch_assoc($res)) {
                                    $x++;
                                    ?>
                                    <tr>
                                        <td class="text-center"><?= $x; ?></td>
                                        <td class="text-center"><?= $data['appliedby']; ?></td>
                                        <td class="text-center"><?= $data['date']; ?></td>
                                        <td class="text-center">
                                            <div class="ms-2">
                                                <h6 class="mb-1 font-14"><?= strtoupper($data['applicant_name']); ?></h6>
                                            </div>
                                        </td>
                                        <td class="text-center"><?= strtoupper($data['mobile']); ?></td>
                                        <td class="text-center"><?= strtoupper($data['gmail']); ?></td>
                                        <td class="text-center"><?= strtoupper($data['application_no']); ?></td>
                                        <td class="text-center"><?= strtoupper($data['address']); ?></td>
                                        
                                        <td class="text-center">
                                            <?php
                                            if ($data['status'] == "pending") {
                                                echo '<span class="badge bg-warning">Pending</span>';
                                            } else if ($data['status'] == "approved") {
                                                echo '<span class="badge bg-success">Approved</span>';
                                            } else if ($data['status'] == "rejected") {
                                                echo '<span class="badge bg-danger">Rejected</span>';
                                            }
                                            ?>
                                        </td>
                                        <td class="text-center">
                                            <?php
                                            if ($data['status'] == "pending") {
                                                ?>
                                                <div style="width:250px;">
                                                    <form method="POST" action="">
                                                        <select class="form-select mb-2" name="status" required>
                                                            <option value="" disabled selected>Select Status</option>
                                                            <option value="approved">Approve</option>
                                                            <option value="rejected">Reject</option>
                                                        </select>
                                                        <input type="hidden" name="id" value="<?= $data['id'] ?>">
                                                        <button class="btn px-6 btn-success">Update</button>
                                                    </form>
                                                </div>
                                                <?php
                                            } else {
                                                ?>
                                                <div class="text-center">
                                                    <?php echo strtoupper($data['status']); ?>
                                                </div>
                                                <?php
                                            }
                                            ?>
                                        </td>
                                    </tr>
                                    <?php
                                }
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<!--end page wrapper -->

<?php 
include('footer.php');
?>

<!-- Bootstrap JS -->
<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
<!--plugins-->
<script src="../template/ahkweb/assets/js/jquery.min.js"></script>
<script src="../template/ahkweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/ahkweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/ahkweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/ahkweb/assets/plugins/chartjs/chart.min.js"></script>
<script src="../template/ahkweb/assets/plugins/vectormap/jquery-jvectormap-2.0.2.min.js"></script>
<script src="../template/ahkweb/assets/plugins/vectormap/jquery-jvectormap-world-mill-en.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery.easy-pie-chart/jquery.easypiechart.min.js"></script>
<script src="../template/ahkweb/assets/plugins/sparkline-charts/jquery.sparkline.min.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery-knob/excanvas.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery-knob/jquery.knob.js"></script>
<script>
$(function() {
    $(".knob").knob();
});
</script>
<script src="../template/ahkweb/assets/js/index.js"></script>
<!--app JS-->
<script src="../template/ahkweb/assets/js/app.js"></script>
<!-- datatable -->
<script src="../template/ahkweb/assets/plugins/datatable/js/jquery.dataTables.min.js"></script>
<script src="../template/ahkweb/assets/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>
<script>
$(document).ready(function() {
    var table = $('#example2').DataTable({
        lengthChange: false,
        buttons: ['copy', 'excel', 'pdf', 'print']
    });

    table.buttons().container()
        .appendTo('#example2_wrapper .col-md-6:eq(0)');
});
</script>

</body>
</html>
