<?php
include('header.php');
?>

		<!--start page wrapper -->
		<div class="page-wrapper">
			<div class="page-content">
				<!--breadcrumb-->
				<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
					<div class="breadcrumb-title pe-3"></div>
					 <img src="data:image/png;base64,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" width="480" height="400" style="border-style: solid; border-width: 3px; pointer-events: all !important;">&nbsp;
					 <img src="data:image/jpeg;base64,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" width="480" height="400" style="border-style: solid; border-width: 3px; pointer-events: all !important;">
					<div class="ps-3">
						<nav aria-label="breadcrumb">
							<ol class="breadcrumb mb-0 p-0">
								<li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
								</li>
								<li class="breadcrumb-item active" aria-current="page">New APPLY</li>
							</ol>
						</nav>
					</div>
					<div class="ms-auto">
						<div class="btn-group">
							<button type="button" class="btn btn-primary">Settings</button>
							<button type="button" class="btn btn-primary split-bg-primary dropdown-toggle dropdown-toggle-split" data-bs-toggle="dropdown">	<span class="visually-hidden">Toggle Dropdown</span>
							</button>
							<div class="dropdown-menu dropdown-menu-right dropdown-menu-lg-end">	<a class="dropdown-item" href="javascript:;">Action</a>
								<a class="dropdown-item" href="javascript:;">Another action</a>
								<a class="dropdown-item" href="javascript:;">Something else here</a>
								<div class="dropdown-divider"></div>	<a class="dropdown-item" href="javascript:;">Separated link</a>
							</div>
						</div>
					</div>
				</div>
				
				<!--end breadcrumb-->
			
				<div class="row">
					<div class="col-x2-20 mx-auto">
						<h6 class="mb-0 text-uppercase">PUC APPPLY </h6>
						<hr/>
						<div class="card border-top border-0 border-4 border-primary">
							<div class="card-body p-5">
								<div class="card-title d-flex align-items-center">
									<div><i class="bx bxs-id-card me-1 font-22 text-primary"></i>
									</div>
									<h5 class="mb-0 text-primary">Enter Customber Detail</h5>
								</div>
								</div>
								<div class="text-left mt-1 powered-by" style="border-radius: 10px; border: 2px solid black; padding: 10px;">
    <p style="color: blue; background: ; font-size: 20px;"><b> ONLY BIKE KA BNEGA.
।</b></p>
</div>
								<hr>
								<form action="" method="POST" class="row g-3" enctype="multipart/form-data">
									<div class="col-md-3">
										<label for="inputFirstName" class="form-label">DIESEL PETROL CNG</label>
										<input name="name" type="text"  placeholder="FUEL NAME"  class="form-control" id="inputFirstName">
									</div>
									</div>
									<div class="col-md-3">
										<label for="inputLastName" class="form-label">Mobile No</label>
										<input name="Mobile_no" type="number" id="Mobile_no"  data-inputmask="AAAAA 9999 A'"   placeholder="Enter Mobail  no" class="form-control" >
									</div>
									
                                    <div class="col-md-3">
                                        <label for="aadhaar_pdf"> Gadi Number Photo PDf</label>
                                        <input type="file" id="aadhaar_pdf" name="aadhaar_pdf" class="form-control" >
                                    </div>
									<!--<div class="col-md-3">-->
									<!--    <label for="inputFirstName" class="form-label">PHOTO UPLOSADS JPG/PNG</label> -->
         <!--                                    <input type="file" name="pdf_file" accept=".jpg/png" required>-->
									<!--</div>-->
									
									<div class="col-12 ml-2">
								       <h5 class="text-warning ">Application Fee: <?php  
										$price = mysqli_fetch_assoc(mysqli_query($ahk_conn,"SELECT price FROM pricing WHERE service_name='puc_fee'")); 
										echo "₹" .$price['price'];
										?></h5>
										<input type="hidden" name="fee" value="<?php echo $price['price'];  ?>">
									</div>
									<div class="col-12">
										<button type="submit" value="Upload" class="btn btn-primary px-5">Apply</button>
									</div>
								</form>
							</div>
						</div>
					
					</div>
				</div>
				
			</div>
		</div>
		
		
		<!--end page wrapper -->
		<?php 
		include('footer.php');
		?>
	<!-- Bootstrap JS -->
	

	<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
	<!--plugins-->
	<!-- <script src="../template/ahkweb/assets/js/jquery.min.js"></script> -->
	<script src="../template/ahkweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
	<script src="../template/ahkweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
	<script src="../template/ahkweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
	<!--app JS-->
	<script src="../template/ahkweb/assets/js/app.js"></script>
</body>

<script>
	$(document).ready(function() {
	
	$('#eid').inputmask();
	$('#date').inputmask();
	$('#timea').inputmask("hh:mm:ss", {
        placeholder: "00:00:00", 
        insertMode: false, 
        showMaskOnHover: false,
        // hourFormat: 24
      });
	});
</script>
</html>