<?php
include('header.php');

// Check if the form has been submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Connect to the database (assuming connection is established in $ahk_conn)

    // Check if a new service is being added
    if (!empty($_POST['new_service_name']) && !empty($_POST['new_service_price'])) {
        // Sanitize input
        $new_service_name = mysqli_real_escape_string($ahk_conn, $_POST['new_service_name']);
        $new_service_price = mysqli_real_escape_string($ahk_conn, $_POST['new_service_price']);

        // Insert the new service into the database
        $insert_query = "INSERT INTO pricing (service_name, price) VALUES ('$new_service_name', '$new_service_price')";
        mysqli_query($ahk_conn, $insert_query);

        $success_message = "New service has been successfully added!";
    } else {
        // Iterate through the POST data and update the prices of existing services
        foreach ($_POST as $service_name => $new_price) {
            if ($service_name != 'new_service_name' && $service_name != 'new_service_price') {
                $service_name = mysqli_real_escape_string($ahk_conn, $service_name);
                $new_price = mysqli_real_escape_string($ahk_conn, $new_price);

                $query = "UPDATE pricing SET price='$new_price' WHERE service_name='$service_name'";
                mysqli_query($ahk_conn, $query);
            }
        }

        $success_message = "Prices have been successfully updated!";
    }
}

// Fetch all the current prices from the database
$query = "SELECT service_name, price FROM pricing";
$result = mysqli_query($ahk_conn, $query);

// Store the prices in an associative array
$prices = [];
while ($row = mysqli_fetch_assoc($result)) {
    $prices[$row['service_name']] = $row['price'];
}
?>

<!-- Start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <!-- Breadcrumb -->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Website Pricing</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">Admin</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <div class="btn-group">
                    <button type="button" class="btn btn-primary">Settings</button>
                </div>
            </div>
        </div>
        <!-- End breadcrumb -->

        <div class="row">
            <div class="col-xl-10 mx-auto">
                <h6 class="mb-0 text-uppercase">Add New Service</h6>
                <hr />
                <div class="card border-top border-0 border-4 border-success shadow-sm mb-4">
                    <div class="card-body p-5">
                        <div class="card-title d-flex align-items-center mb-4">
                            <div><i class="bx bx-plus me-2 font-22 text-success"></i></div>
                            <h5 class="mb-0 text-success">Add New Service</h5>
                        </div>

                        <!-- Display success message after update -->
                        <?php if (isset($success_message)): ?>
                            <div class="alert alert-success" role="alert">
                                <?= $success_message; ?>
                            </div>
                        <?php endif; ?>

                        <!-- Form to add new service -->
                        <form action="" method="POST" class="row g-3">
                            <div class="col-md-6">
                                <label for="new_service_name" class="form-label">Service Name</label>
                                <input name="new_service_name" type="text" class="form-control shadow-sm" id="new_service_name" placeholder="Enter new service name">
                            </div>

                            <div class="col-md-6">
                                <label for="new_service_price" class="form-label">Service Price</label>
                                <input name="new_service_price" type="text" class="form-control shadow-sm" id="new_service_price" placeholder="Enter new service price">
                            </div>

                            <!-- Submit Button for New Service -->
                            <div class="col-12 text-end mt-4">
                                <button type="submit" class="btn btn-success btn-lg shadow-sm">Add Service</button>
                            </div>
                        </form>

                    </div>
                </div>

                <!-- Update Pricing Section -->
                <h6 class="mb-0 text-uppercase">Update Existing Service Prices</h6>
                <hr />
                <div class="card border-top border-0 border-4 border-primary shadow-sm">
                    <div class="card-body p-5">
                        <div class="card-title d-flex align-items-center mb-4">
                            <div><i class="bx bxs-cog me-2 font-22 text-primary"></i></div>
                            <h5 class="mb-0 text-primary">Update Prices</h5>
                        </div>

                        <!-- Form to update pricing details -->
                        <form action="" method="POST" class="row g-3">

                            <!-- Update existing services with improved design -->
                            <?php foreach ($prices as $service_name => $price): ?>
                            <div class="col-md-6 mb-3">
                                <label for="<?= $service_name ?>" class="form-label"><?= ucwords(str_replace('_', ' ', $service_name)) ?></label>
                                <input name="<?= $service_name ?>" value="<?= $price ?>" type="text" class="form-control shadow-sm" id="<?= $service_name ?>" placeholder="Enter price for <?= $service_name ?>">
                            </div>
                            <?php endforeach; ?>

                            <!-- Submit Button for Update Prices -->
                            <div class="col-12 text-end mt-4">
                                <button type="submit" class="btn btn-primary btn-lg shadow-sm">Update Prices</button>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- End page wrapper -->

<!-- Custom CSS -->
<style>
    .page-content {
        background-color: #f8f9fa;
        padding: 40px;
    }
    .card {
        border-radius: 12px;
        background-color: #ffffff;
    }
    .card-body {
        padding: 30px;
    }
    .form-label {
        font-weight: 500;
        color: #333;
    }
    .form-control {
        height: 45px;
        border-radius: 8px;
        padding: 10px 15px;
    }
    .btn-primary {
        background-color: #007bff;
        border-color: #007bff;
    }
    .btn-primary:hover {
        background-color: #0056b3;
        border-color: #0056b3;
    }
    .btn-success {
        background-color: #28a745;
        border-color: #28a745;
    }
    .btn-success:hover {
        background-color: #218838;
        border-color: #1e7e34;
    }
    .shadow-sm {
        box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075) !important;
    }
</style>
