<?php
// Include session and database configuration
include('header.php');

// Fetch current user details
$current_user = mysqli_query($ahk_conn, "SELECT * FROM users WHERE phone='".$udata['phone']."'");
$user_data = mysqli_fetch_assoc($current_user);

// Get current role, balance, and premium status
$current_role = $user_data['type'];
$current_balance = $user_data['balance'];
$premium_status = $user_data['premium'];

// Set premium activation cost
$premium_cost = 199;

// Check if user has enough balance to activate premium
$activation_message = '';
if ($premium_status === 'active') {
    $activation_message = "<h3>Your premium status is already active.</h3>";
} else if ($current_balance >= $premium_cost) {
    if (isset($_POST['activate_premium'])) {
        // Deduct balance for premium activation
        $new_balance = $current_balance - $premium_cost;

        // Update user's premium status and balance in the database
        $update_query = "UPDATE users SET balance='$new_balance', premium='active' WHERE phone='".$udata['phone']."'";
        $update_status = mysqli_query($ahk_conn, $update_query);

        if ($update_status) {
            // Show success message using SweetAlert
            echo "<script>
                    Swal.fire({
                        title: 'Premium Activated!',
                        text: 'Your premium status has been activated successfully.',
                        icon: 'success'
                    });
                    setTimeout(() => { window.location='index.php'; }, 1500);
                  </script>";
        } else {
            // Show error message using SweetAlert
            echo "<script>
                    Swal.fire({
                        title: 'Activation Failed!',
                        text: 'There was an issue activating your premium status. Please try again.',
                        icon: 'error'
                    });
                  </script>";
        }
    }
} else {
    $activation_message = "<h3>Your balance is insufficient. You need at least ₹{$premium_cost} to activate premium.</h3>";
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Premium Benefits</title>
    <!-- Include SweetAlert CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@10/dist/sweetalert2.min.css">
    <style>
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            background-image: url('https://via.placeholder.com/1920x1080'); /* Placeholder URL for background */
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
        }
        .container {
            max-width: 600px;
            width: 100%;
            background: rgba(255, 255, 255, 0.9); /* Semi-transparent background */
            padding: 30px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
            border-radius: 10px;
            text-align: center;
        }
        .card {
            background: #fff;
            border-radius: 10px;
            padding: 20px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
            margin: 20px;
        }
        .card-header {
            font-size: 24px;
            font-weight: bold;
            color: #333;
            margin-bottom: 15px;
        }
        .card-body {
            font-size: 16px;
            color: #555;
            margin-bottom: 20px;
        }
        .card-body ul {
            list-style-type: none;
            padding: 0;
        }
        .card-body li {
            margin-bottom: 10px;
        }
        .btn-activate {
            display: block;
            width: 100%;
            padding: 12px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 25px;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.3s ease;
        }
        .btn-activate:hover {
            background-color: #0056b3;
        }
        .btn-activate:focus {
            outline: none;
        }
    </style>
</head>
<body>

<div class="container">
    <div class="card">
        <div class="card-header">
            Premium Benefits
        </div>
        <div class="card-body">
            <?php
            // Display activation message
            echo $activation_message;
            ?>
            <?php if ($premium_status !== 'active' && $current_balance >= $premium_cost): ?>
                <p>Activate your premium status and enjoy a host of exclusive services:</p>
                <ul>
                    <li>Access to all premium features and content.</li>
                    <li>Priority customer support for faster resolutions.</li>
                    <li>Exclusive discounts and offers on various services.</li>
                    <li>Early access to new features and updates.</li>
                    <li>Ad-free experience for uninterrupted usage.</li>
                </ul>
                <p>All this for just ₹199!</p>
                <form method="post" action="">
                    <button type="submit" name="activate_premium" class="btn-activate">Activate Premium Now</button>
                </form>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Include SweetAlert JS Library -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>

</body>
</html>
