<?php include('header.php'); ?>
					<!--begin::Content-->
					<div class="docs-content d-flex flex-column flex-column-fluid" id="kt_docs_content">
						<!--begin::Container-->
						<div class="container d-flex flex-column flex-lg-row" id="kt_docs_content_container">
							<!--begin::Card-->
							<div class="card card-docs flex-row-fluid mb-2">
								<!--begin::Card Body-->
								<div class="card-body fs-6 py-15 px-10 py-lg-15 px-lg-15 text-gray-700">
									<!--begin::Notice-->
									<div class="d-flex align-items-center rounded py-5 px-4 bg-light-info">
										<!--begin::Icon-->
										<div class="d-flex h-80px w-80px flex-shrink-0 flex-center position-relative ms-3 me-6">
											<!--begin::Svg Icon | path: icons/duotune/abstract/abs051.svg-->
											<span class="svg-icon svg-icon-info position-absolute opacity-10">
												<svg class=". w-80px h-80px ." xmlns="http://www.w3.org/2000/svg" width="70px" height="70px" viewBox="0 0 70 70" fill="none">
													<path d="M28 4.04145C32.3316 1.54059 37.6684 1.54059 42 4.04145L58.3109 13.4585C62.6425 15.9594 65.3109 20.5812 65.3109 25.5829V44.4171C65.3109 49.4188 62.6425 54.0406 58.3109 56.5415L42 65.9585C37.6684 68.4594 32.3316 68.4594 28 65.9585L11.6891 56.5415C7.3575 54.0406 4.68911 49.4188 4.68911 44.4171V25.5829C4.68911 20.5812 7.3575 15.9594 11.6891 13.4585L28 4.04145Z" fill="currentColor" />
												</svg>
											</span>
											<!--end::Svg Icon-->
											<!--begin::Svg Icon | path: icons/duotune/art/art006.svg-->
											<span class="svg-icon svg-icon-3x svg-icon-info position-absolute">
												<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
													<path opacity="0.3" d="M22 19V17C22 16.4 21.6 16 21 16H8V3C8 2.4 7.6 2 7 2H5C4.4 2 4 2.4 4 3V19C4 19.6 4.4 20 5 20H21C21.6 20 22 19.6 22 19Z" fill="currentColor" />
													<path d="M20 5V21C20 21.6 19.6 22 19 22H17C16.4 22 16 21.6 16 21V8H8V4H19C19.6 4 20 4.4 20 5ZM3 8H4V4H3C2.4 4 2 4.4 2 5V7C2 7.6 2.4 8 3 8Z" fill="currentColor" />
												</svg>
											</span>
											<!--end::Svg Icon-->
										</div>
										<!--end::Icon-->
										<!--begin::Description-->
										<div class="text-gray-700 fw-bold fs-6 lh-lg">How to Integrate PAN FIND API in your website
										<a class="fw-semibold me-1" href="https://apizone.in/dashboard/API_List" target="_blank">Active it</a>. Easy Steps</div>
										<!--end::Description-->
									</div>
									<!--end::Notice-->
									<h1 class="anchor fw-bold mb-5" id="gulp-quick-start" data-kt-scroll-offset="50">
										<a href="#gulp-quick-start"></a>Integration of PAN Find API.</h1>
									<!--begin::Section-->
									<div class="py-10">
										<!--begin::Heading-->
										<h1 class="anchor fw-bold mb-5" id="gulp-quick-start" data-kt-scroll-offset="50">
										<a href="#gulp-quick-start"></a>Request to Our Server.</h1>
										<!--end::Heading-->
										<div class="row m-5">
										<div class="col-md-12">
											<hr>
											<h2 class="text-info">Paramater List</h2>
										</div>
										<style>
											#customers {
											  font-family: Arial, Helvetica, sans-serif;
											  border-collapse: collapse;
											  width: 100%;
											}
											
											#customers td, #customers th {
											  border: 1px solid #ddd;
											  padding: 8px;
											}
											
											#customers tr:nth-child(even){background-color: #f2f2f2;}
											
											#customers tr:hover {background-color: #ddd;}
											
											#customers th {
											  padding-top: 12px;
											  padding-bottom: 12px;
											  text-align: left;
											  background-color: #04AA6D;
											  color: white;
											}
											</style>
										<div class="col-md-12">
											<table id="customers"  class="table table-bordered table-striped">
												<thead>
													<tr>
														<th width="200px">Param Name</th>
														<th>Desc</th>
														<th width="100px">Required</th>
													</tr>
												</thead>
												<tbody>
													<tr>
														<td>application_no</td>
														<td>Unique Application No (Below 200 Character) <br>Example: AHK123456789</td>
														<td>Yes</td>
													</tr>
													<tr>
														<td>name</td>
														<td>Name as Per Aadhaar <br>
														Ex:- Chandan Kumar
														</td>
														<td>Yes</td>
													</tr>
													<tr>
														<td>aadhaar_no</td>
														<td>Customer AADHAAR Number (12 Digit, you can add Space Next to Each 4 Digit).<br>
                                                            Ex:- 1234 1234 1234</td>
														<td>Yes</td>
													</tr>
													<tr>
														<td>dob</td>
														<td>Customer Date or Birth<br>Example: 10/12/1994 (Format:  DD/MM/YYYY )</td>
														<td>Yes</td>
													</tr>
													<tr>
														<td>ret_wp_no</td>
														<td>Retailer Whatsapp Number (Number of Person Who Filling The Form)<br>Example: 9999999999</td>
														<td>Yes</td>
													</tr>
													<tr>
														<td>callback_url</td>
														<td>CallBack URL (Provide Callback or Webhook URL in this  Path You Will Get The Data in any condition (True, False))<br>Example: https://yourdomain.com/admin/PanWebhook.php</td>
														<td>Yes</td>
													</tr>
													<tr>
														<td>api_key</td>
														<td>API KEY (Its very Important to HIT our Server) <br>Example: 5e1c2b0103f59fcb5d66b7gfe170477760 <a target="_blank" href="https://apizone.in/dashboard/account/api-keys">GET API</a> </td>
														<td>Yes</td>
													</tr>
												</tbody>
											</table>
										</div>
									</div>
										<!--begin::List-->
										<ol class="py-5">
											<li class="py-3">Sample PHP cURL Code 
											<code>/POST</code>: 
											<div class="py-5">
												<!--begin::Highlight-->
												<div class="highlight">
													<button class="highlight-copy btn" data-bs-toggle="tooltip" title="Copy code">copy</button>
													<div class="highlight-code">
														<pre class="language-bash">
<code class="language-bash">
    $api_key = ""; // API Key Here
    $application_no = base64_encode("AHK". rand(00000000,99999999)); // Base 64 Encoded Application Number
    $name = base64_encode(""); // Base 64 Encoded Customer Name
    $aadhaar_no = base64_encode(""); // Base 64 Encoded Aadhaar Number
    $dob = base64_encode(""); // Base 64 Encoded Date of birth
    $ret_wp_no = base64_encode(""); // Base 64 Encoded Retailer Whatsaap Number
    $callback_url = base64_encode(""); // Base 64 Encoded Webhook URL / CallBack URL

    $url = 'https://apizone.in/api/v1/services/pan_no/submit.php?application_no='.$application_no.'&name='.$name.'&aadhaar_no='.$aadhaar_no.'&dob='.$dob.'&ret_wp_no='.$ret_wp_no.'&api_key='.$api_key.'&callback_url='.$callback_url;

    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
    ));
    $response = curl_exec($curl);
    curl_close($curl);
        $response;
    $resdata = json_decode($response,true);

</code>
</pre>
													</div>
												</div>
												<!--end::Highlight-->
											</div></li>
											<li class="py-3">
											<h2 class="text-success">Success Response Sample JSON Data</h2>
											<div class="py-5">
												<!--begin::Highlight-->
												<div class="highlight">
													<button class="highlight-copy btn" data-bs-toggle="tooltip" title="Copy code">copy</button>
													<div class="highlight-code">
														<pre class="language-bash">
<code class="language-bash">
{
    "status" : 1,
    "message" : "Application Submitted Successful",
    "application_no" : "AHK123456789",
}
                   

</code>
</pre>
													</div>
												</div>
												<!--end::Highlight-->
											</div>
											<div class="col-md-12">
											<hr>
											<h2 class="text-info">Success Paramater List</h2>
										</div>
										
										<div class="col-md-12">
											<table id="customers"  class="table table-bordered table-striped">
												<thead>
													<tr>
														<th width="200px">Param Name</th>
														<th>Desc</th>
													</tr>
												</thead>
												<tbody>
													<tr>
														<td>status</td>
														<td>It Will Return 1 or 0 (if Success then it will 1)</td>
													</tr>
													<tr>
														<td>message</td>
														<td>It will tell What happen Against that Transaction</td>
													</tr>
													
													<tr>
														<td>application_no</td>
														<td>Unique Application Number From API Portal for Future Update</td>
													</tr>
													
												</tbody>
											</table>
										</div>
											</li>
											<li class="py-3">
											<h2 class="text-danger">Failed Response Sample JSON Data</h2> 
											<div class="py-5">
												<!--begin::Highlight-->
												<div class="highlight">
													<button class="highlight-copy btn" data-bs-toggle="tooltip" title="Copy code">copy</button>
													<div class="highlight-code">
														<pre class="language-javascript">
<code class="language-bash">
{
	"status" : 0,
	"message" : "Failed Reason",
}


</code>
</pre>
													</div>
												</div>
												<!--end::Highlight-->
											</div>
											<div class="col-md-12">
											<hr>
											
											<h2 class="text-danger">Failed Paramater List</h2>
											</div>
										
										<div class="col-md-12">
											<table id="customers"  class="table table-bordered table-striped">
												<thead>
													<tr>
														<th width="200px">Param Name</th>
														<th>Desc</th>
													</tr>
												</thead>
												<tbody>
													<tr>
														<td>status</td>
														<td>0 if Failed</td>
													</tr>
													<tr>
														<td>message</td>
														<td>Failed Reason</td>
													</tr>
													
												</tbody>
											</table>
										</div>
</li>

										</ol>
										<!--end::List-->
									</div>
									<!--end::Section-->
									<!--begin::Section-->
									<div class="py-10">
										<!--begin::Heading-->
										<h1 class="anchor fw-bold mb-5" id="build-options" data-kt-scroll-offset="50">
										<a href="#build-options"></a>Parameters will be Sent you Via Webhook URL / CallBack URL in status 0 or 1</h1>
										<!--end::Heading-->
										<!--begin::Block-->
										<div class="pt-5">Webhook Parameters List</div>
										<!--end::Block-->
										
										
										<div class="col-md-12">
											<table id="customers"  class="table table-bordered table-striped">
												<thead>
                                                <tr>
                                                    <th width="200px">Param Name</th>
                                                    <th>Description</th>
                                                </tr>
												</thead>
												<tbody>
                                                <tr>
                                                    <td>application_no</td>
                                                    <td>Unique Application Number That Provided by you</td>
                                                </tr>
                                                <tr>
                                                    <td>pan_no</td>
                                                    <td>Pan Number If Generated <br>Example: ABCDE1234E</td>
                                                </tr>
                                
                                    
                                                                    </tbody>
											</table>
										</div>
										<hr>
										
										
										
									</div>
									<!--end::Section-->
									<!--begin::Section-->
									<div class="py-10">
										<!--begin::Heading-->
										<h1 class="anchor fw-bold mb-5" id="check_status" data-kt-scroll-offset="50">
										<a href="#check_status"></a>Check Status API </h1>
										<!--end::Heading-->
										<!--begin::Block-->
										<div class="pt-5">Check Status parameter</div>
										<!--end::Block-->
										
										
										<div class="col-md-12">
											<table id="customers"  class="table table-bordered table-striped">
												<thead>
                                                <tr>
                                                    <th width="200px">Param Name</th>
                                                    <th>Description</th>
                                                </tr>
												</thead>
												<tbody>
                                                <tr>
                                                    <td>application_no</td>
                                                    <td>base 64 Encoded Application No <br>Ex: AHK123456789</td>
                                                </tr>
                                                <tr>
                                                    <td>api_key</td>
													<td>API KEY (Its very Important to HIT our Server) <br>Example: 5e1c2b0103f59fcb5d66b7gfe170477760 <a target="_blank" href="https://apizone.in/dashboard/account/api-keys">GET API</a> </td>
                                                </tr>
                                
                                    
                                                                    </tbody>
											</table>
										</div>
										
										
											<h2 class="text-success">Request Code Using get Method</h2> 
											<div class="py-5">
												<!--begin::Highlight-->
												<div class="highlight">
													<button class="highlight-copy btn" data-bs-toggle="tooltip" title="Copy code">copy</button>
													<div class="highlight-code">
														<pre class="language-javascript">
<code class="language-bash">
$application_no = base64_encode(""); // Application Number base64 Encoded
$api_key = ""; // API Key  from https://apizone.in/dashboard/account/api-keys

$url = 'https://apizone.in/api/v1/services/pan_no/track.php?application_no='.$application_no.'&api_key='.$api_key;
$curl = curl_init();
curl_setopt_array($curl, array(
CURLOPT_URL => $url,
CURLOPT_RETURNTRANSFER => true,
CURLOPT_ENCODING => "",
CURLOPT_MAXREDIRS => 10,
CURLOPT_TIMEOUT => 0,
CURLOPT_FOLLOWLOCATION => true,
CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
CURLOPT_CUSTOMREQUEST => "GET",
));
$response = curl_exec($curl);
curl_close($curl);
$response;
$resdata = json_decode($response,true);

</code>
</pre>
													</div>
												</div>
												<!--end::Highlight-->
											</div>
											<hr>
											<h2 class="text-success">Success Response Sample JSON Data</h2> 
											<div class="py-5">
												<!--begin::Highlight-->
												<div class="highlight">
													<button class="highlight-copy btn" data-bs-toggle="tooltip" title="Copy code">copy</button>
													<div class="highlight-code">
														<pre class="language-javascript">
<code class="language-bash">
{
	"status" : 1,
	"message" : "Success Message",
	"pan_no" : "ABCDE1234E",
}


</code>
</pre>
													</div>
												</div>
												<!--end::Highlight-->
											</div>
											<hr>
									</div>
									<!--end::Section-->
									
									
								</div>
								<!--end::Card Body-->
							</div>
							<!--end::Card-->
							<!--begin::Sidebar wrapper-->
							<div class="ms-7 flex-row-auto w-lg-200px">
								<!--begin::Sidebar nav-->
								<div class="card card-flush d-none d-lg-flex" data-kt-sticky="true" data-kt-sticky-name="sidebar-navs" data-kt-sticky-offset="{default: false, lg: 200}" data-kt-sticky-width="200px" data-kt-sticky-animation="false" data-kt-sticky-left="auto" data-kt-sticky-top="25px" data-kt-sticky-zindex="95">
									<!--begin::Card body-->
									<div class="card-body px-0 px-3 py-6">
										<!--begin::Menu-->
										<ul id="kt_sidebar_nav" class="nav nav-flush menu menu-column menu-title-gray-700 menu-bullet-gray-300 menu-state-primary fw-semibold fs-6">
											<!--begin::Item-->
											<li class="menu-item py-2 px-3">
												<!--begin::Link-->
												<a href="#gulp-quick-start" data-kt-scroll-toggle="true" class="menu-link p-0 nav-link">
													<span class="menu-bullet">
														<span class="bullet bullet-dot"></span>
													</span>
													<span class="menu-title">Create POST Code</span>
												</a>
												<!--end::Link-->
											</li>
											<!--end::Item-->
											<!--begin::Item-->
											<li class="menu-item py-2 px-3">
												<!--begin::Link-->
												<a href="#build-options" data-kt-scroll-toggle="true" class="menu-link p-0 nav-link">
													<span class="menu-bullet">
														<span class="bullet bullet-dot"></span>
													</span>
													<span class="menu-title">Webhook Response Param</span>
												</a>
												<!--end::Link-->
											</li>
											<!--end::Item-->
											<!--begin::Item-->
											<li class="menu-item py-2 px-3">
												<!--begin::Link-->
												<a href="#check_status" data-kt-scroll-toggle="true" class="menu-link p-0 nav-link">
													<span class="menu-bullet">
														<span class="bullet bullet-dot"></span>
													</span>
													<span class="menu-title">Check Status API</span>
												</a>
												<!--end::Link-->
											</li>
											<!--end::Item-->
										
										
										</ul>
										<!--end::Menu-->
									</div>
									<!--end::Card body-->
								</div>
								<!--end::Sidebar nav-->
							</div>
							<!--end::Sidebar wrapper-->
						</div>
						<!--end::Container-->
					</div>
					<!--end::Content-->
					<?php 
include('footer.php');
?>