<?php
include('header.php');

// Fetch all applications
$result = mysqli_query($ahk_conn, "SELECT * FROM llms_applications");
?>

<div class="container mt-5">
    <div class="card shadow-lg p-5 border-0">
        <h2 class="text-center mb-4 font-weight-bold text-primary">User Application Details</h2>

        <!-- Application Details -->
        <div class="row mb-3">
            <div class="col-md-12">
                <?php while ($row = mysqli_fetch_assoc($result)): ?>
                    <div class="card mb-4 border-left-primary shadow-sm">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-3 mb-3">
                                    <strong>Application No:</strong> <?php echo htmlspecialchars($row['application_no']); ?>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <strong>Name:</strong> <?php echo htmlspecialchars($row['student_name']); ?>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <strong>Email:</strong> <?php echo htmlspecialchars($row['email']); ?>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <strong>Mobile:</strong> <?php echo htmlspecialchars($row['mobile']); ?>
                                </div>
                            </div>

                            <div class="row mt-2">
                                <div class="col-md-3">
                                    <strong>Aadhaar No:</strong> <?php echo htmlspecialchars($row['aadhaar_no']); ?>
                                </div>
                                <div class="col-md-3">
                                    <strong>District:</strong> <?php echo htmlspecialchars($row['district']); ?>
                                </div>
                                <div class="col-md-3">
                                    <strong>State:</strong> <?php echo htmlspecialchars($row['state']); ?>
                                </div>
                                <div class="col-md-3">
                                    <strong>Fee:</strong> <?php echo htmlspecialchars($row['fee']); ?>
                                </div>
                            </div>

                            <div class="row mt-3">
                                <div class="col-md-3">
                                    <strong>Date:</strong> <?php echo htmlspecialchars($row['date']); ?>
                                </div>
                                <div class="col-md-3">
                                    <strong>Status:</strong>
                                    <span class="badge badge-<?php echo $row['status'] == 'approved' ? 'success' : 'warning'; ?>">
                                        <?php echo ucfirst(htmlspecialchars($row['status'])); ?>
                                    </span>
                                </div>
                                <div class="col-md-3">
                                    <?php if ($row['status'] == 'approved' && $row['pdf_file']): ?>
                                        <a href="uploads/<?php echo htmlspecialchars($row['pdf_file']); ?>" target="_blank" class="btn btn-info btn-sm">Download PDF</a>
                                    <?php else: ?>
    <button class="btn btn-warning btn-sm" disabled>Pending</button>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
        </div>
    </div>
</div>

<script>
// Show the file name in the custom file input
$('.custom-file-input').on('change', function() {
    var fileName = $(this).val().split('\\').pop();
    $(this).siblings('.custom-file-label').addClass('selected').html(fileName);
});
</script>

<?php include('footer.php'); ?>
