<?php
include('header.php');

// Handle PDF upload
if (isset($_POST['upload_pdf'])) {
    $application_no = mysqli_real_escape_string($ahk_conn, $_POST['application_no']);
    $pdf_file = $_FILES['pdf_file']['name'];
    $pdf_temp = $_FILES['pdf_file']['tmp_name'];

    // Move PDF to uploads directory
    move_uploaded_file($pdf_temp, "uploads/" . $pdf_file);

    // Update application with PDF path and set status to 'Approved'
    mysqli_query($ahk_conn, "UPDATE llms_applications SET pdf_file='$pdf_file', status='approved' WHERE application_no='$application_no'");

    echo '<div class="alert alert-success">PDF uploaded successfully and status set to Approved.</div>';
}

// Fetch all applications
$result = mysqli_query($ahk_conn, "SELECT * FROM llms_applications");
?>
<div class="container mt-5">
    <div class="card shadow-lg p-5 border-0">
        <h2 class="text-center mb-4 font-weight-bold text-primary">Admin: User Application Details</h2>

        <!-- Application Details -->
        <div class="row mb-3">
            <div class="col-md-12">
                <?php while ($row = mysqli_fetch_assoc($result)): ?>
                    <div class="card mb-4 border-left-primary shadow-sm">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-3 mb-3">
                                    <strong>Application No:</strong> <?php echo $row['application_no']; ?>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <strong>Name:</strong> <?php echo $row['student_name']; ?>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <strong>Email:</strong> <?php echo $row['email']; ?>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <strong>Mobile:</strong> <?php echo $row['mobile']; ?>
                                </div>
                            </div>

                            <div class="row mt-2">
                                <div class="col-md-3">
                                    <strong>Aadhaar No:</strong> <?php echo $row['aadhaar_no']; ?>
                                </div>
                                <div class="col-md-3">
                                    <strong>District:</strong> <?php echo $row['district']; ?>
                                </div>
                                <div class="col-md-3">
                                    <strong>State:</strong> <?php echo $row['state']; ?>
                                </div>
                                <div class="col-md-3">
                                    <strong>Fee:</strong> <?php echo $row['fee']; ?>
                                </div>
                            </div>

                            <div class="row mt-3">
                                <div class="col-md-3">
                                    <strong>Date:</strong> <?php echo $row['date']; ?>
                                </div>
                                <div class="col-md-3">
                                    <strong>Status:</strong> 
                                    <span class="badge badge-<?php echo $row['status'] == 'approved' ? 'success' : 'warning'; ?>">
                                        <?php echo ucfirst($row['status']); ?>
                                    </span>
                                </div>
                                <div class="col-md-3">
                                    <strong>PDF:</strong>
                                    <?php if ($row['pdf_file']): ?>
                                        <a href="uploads/<?php echo $row['pdf_file']; ?>" target="_blank" class="btn btn-info btn-sm">View PDF</a>
                                    <?php else: ?>
                                        <span class="text-danger">No PDF Uploaded</span>
                                    <?php endif; ?>
                                </div>
                                <div class="col-md-3">
                                    <?php if (!$row['pdf_file']): ?>
                                        <form action="" method="POST" enctype="multipart/form-data">
                                            <input type="hidden" name="application_no" value="<?php echo $row['application_no']; ?>">
                                            <div class="custom-file">
                                                <input type="file" name="pdf_file" class="custom-file-input" required>
                                                <label class="custom-file-label">Choose file</label>
                                            </div>
                                            <button type="submit" name="upload_pdf" class="btn btn-success btn-sm mt-2">Upload</button>
                                        </form>
                                    <?php else: ?>
                                        <span class="text-success">Already Uploaded</span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
        </div>
    </div>
</div>

<script>
// Show the file name in the custom file input
$('.custom-file-input').on('change', function() {
    var fileName = $(this).val().split('\\').pop();
    $(this).siblings('.custom-file-label').addClass('selected').html(fileName);
});
</script>
