<?php
include('header.php');

// Initialize error and success messages
$error_message = '';
$success_message = '';

// Check if form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Retrieve form data
    $student_name = mysqli_real_escape_string($ahk_conn, $_POST['student_name']);
    $email = mysqli_real_escape_string($ahk_conn, $_POST['email']);
    $mobile = mysqli_real_escape_string($ahk_conn, $_POST['mobile']);
    $aadhaar_no = mysqli_real_escape_string($ahk_conn, $_POST['aadhaar_no']);
    $district = mysqli_real_escape_string($ahk_conn, $_POST['district']);
    $state = mysqli_real_escape_string($ahk_conn, $_POST['state']);
    $fee = 1500;  // Set fee to 1500
    $appliedby = $udata['phone'];
    $application_no = "LLMS" . rand(10000000, 99999999); // Generate a unique application number
    $date = date("Y-m-d H:i:s");

    // Check if user balance is sufficient
    if ($udata['balance'] >= $fee) {
        $nbal = $udata['balance'] - $fee;

        // Update user balance
        $debit = mysqli_query($ahk_conn, "UPDATE users SET balance=balance-$fee WHERE phone='$appliedby'");

        // Log transaction in history
        $updatehistory = mysqli_query($ahk_conn, "INSERT INTO `wallethistory`(`userid`, `amount`, `balance`, `purpose`, `status`, `type`) VALUES ('$appliedby','$fee','$nbal','LLMS Application Fee','1','Debit')");

        if ($debit && $updatehistory) {
            // Insert user details into the database
            $submit = mysqli_query($ahk_conn, "INSERT INTO `llms_applications` (`appliedby`, `application_no`, `student_name`, `email`, `mobile`, `aadhaar_no`, `district`, `state`, `status`, `fee`, `date`) VALUES ('$appliedby', '$application_no', '$student_name', '$email', '$mobile', '$aadhaar_no', '$district', '$state', 'pending', '$fee', '$date')");

            if ($submit) {
                $success_message = 'Application submitted successfully.';
            } else {
                $error_message = 'Failed to submit application. Please try again.';
            }
        } else {
            $error_message = 'Failed to update balance. Please try again.';
        }
    } else {
        $error_message = 'Insufficient balance. Please recharge your wallet.';
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <!-- Required meta tags and CSS -->
</head>
<body>
<!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">LLMS Application</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">LLMS Application Form</li>
                    </ol>
                </nav>
            </div>
        </div>
        <!--end breadcrumb-->
        
        <div class="row">
            <div class="col-xl-10 mx-auto">
                <div class="card border-top border-0 border-4 border-primary">
                    <div class="card-body p-5">
                        <div class="card-title d-flex align-items-center">
                            <div><i class="bx bx-user me-1 font-22 text-primary"></i></div>
                            <h5 class="mb-0 text-primary">LLMS Application Form</h5>
                        </div>
                        <hr>

                        <!-- Display success or error message -->
                        <?php if ($success_message): ?>
                            <div class="alert alert-success" role="alert">
                                <?php echo $success_message; ?>
                            </div>
                        <?php endif; ?>
                        <?php if ($error_message): ?>
                            <div class="alert alert-danger" role="alert">
                                <?php echo $error_message; ?>
                            </div>
                        <?php endif; ?>

                        <form action="" method="POST" class="row g-3">
                            <!-- Student Name -->
                            <div class="col-md-6">
                                <label for="student_name" class="form-label">Student Name:</label>
                                <input type="text" id="student_name" name="student_name" class="form-control" required>
                            </div>

                            <!-- Mobile Number -->
                            <div class="col-md-6">
                                <label for="mobile" class="form-label">Mobile Number:</label>
                                <input type="text" id="mobile" name="mobile" class="form-control" data-inputmask="'mask': '9999999999'" placeholder="Enter 10-digit mobile number" required>
                                <small>Enter a valid 10-digit mobile number.</small>
                            </div>

                            <!-- Email -->
                            <div class="col-md-6">
                                <label for="email" class="form-label">Email:</label>
                                <input type="email" id="email" name="email" class="form-control" required>
                            </div>

                            <!-- Aadhaar Number -->
                            <div class="col-md-6">
                                <label for="aadhaar_no" class="form-label">Aadhaar Number:</label>
                                <input type="text" id="aadhaar_no" name="aadhaar_no" class="form-control" data-inputmask="'mask': '9999 9999 9999'" placeholder="Enter Aadhaar Number" required>
                            </div>

                            <!-- District -->
                            <div class="col-md-6">
                                <label for="district" class="form-label">District:</label>
                                <input type="text" id="district" name="district" class="form-control" required>
                            </div>

                            <!-- State -->
                            <div class="col-md-6">
                                <label for="state" class="form-label">State:</label>
                                <input type="text" id="state" name="state" class="form-control" required>
                            </div>
<div class="col-12">
    <label for="fee" class="form-label">Application Fee:</label>
    <input type="text" id="fee" name="fee" class="form-control" value="₹1500" readonly>
</div>
                            <!-- Submit Button -->
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary px-5">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!--end page wrapper -->

<?php 
include('footer.php');
?>

<!-- Bootstrap JS -->
<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
<script src="../template/ahkweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/ahkweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/ahkweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<!--app JS-->
<script src="../template/ahkweb/assets/js/app.js"></script>

<!-- Inputmask for number -->
<script>
    $(document).ready(function() {
        $('#mobile').inputmask(); // Masking the phone number input
        $('#aadhaar_no').inputmask(); // Masking the Aadhaar number input
    });
</script>

</body>
</html>
