<?php
include('header.php');

// Initialize error and success messages
$error_message = '';

// Fetch data from the database
$query = "SELECT * FROM authorization_letters";
$result = mysqli_query($ahk_conn, $query);

if (!$result) {
    $error_message = 'Failed to fetch data. Please try again.';
}

// Function to export data to CSV
function exportToCSV($data) {
    $filename = "authorization_letters_" . date('Y-m-d') . ".csv";
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment;filename=' . $filename);
    
    $output = fopen('php://output', 'w');
    
    // Header row
    fputcsv($output, array('Serial No', 'Application No', 'Student Name', 'Father Name', 'Aadhaar No', 'District', 'State', 'Passport Size Photo', 'PDF File', 'Status', 'Fee', 'Date'));
    
    // Data rows
    $serial_no = 1;
    while ($row = mysqli_fetch_assoc($data)) {
        $row['Serial No'] = $serial_no++;
        fputcsv($output, $row);
    }
    
    fclose($output);
    exit();
}

// Check if download request is made
if (isset($_POST['download_csv'])) {
    exportToCSV(mysqli_query($ahk_conn, $query));
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Authorization Letters List</title>
    <link rel="stylesheet" href="../template/ahkweb/assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="../template/ahkweb/assets/css/style.css">
    <style>
        .table-container {
            margin-top: 20px;
        }
        .download-btn {
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
<!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Authorization Letters List</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">List of Authorization Letters</li>
                    </ol>
                </nav>
            </div>
        </div>
        <!--end breadcrumb-->

        <div class="row">
            <div class="col-xl-12 mx-auto">
                <div class="card border-top border-0 border-4 border-primary">
                    <div class="card-body p-5">
                        <div class="card-title d-flex align-items-center">
                            <div><i class="bx bx-list me-1 font-22 text-primary"></i></div>
                            <h5 class="mb-0 text-primary">Authorization Letters List</h5>
                        </div>
                        <hr>

                        <!-- Display error message -->
                        <?php if ($error_message): ?>
                            <div class="alert alert-danger" role="alert">
                                <?php echo $error_message; ?>
                            </div>
                        <?php endif; ?>

                        <!-- Download Button -->
                     

                        <div class="table-container">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>Serial No</th>
                                        <th>Application No</th>
                                        <th>Student Name</th>
                                        <th>Father Name</th>
                                        <th>Aadhaar No</th>
                                        <th>District</th>
                                        <th>State</th>
                                        <th>Passport Size Photo</th>
                                        <th>PDF File</th>
                                        <th>Status</th>
                                        <th>Fee</th>
                                        <th>Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $serial_no = 1; // Initialize serial number counter
                                    while ($row = mysqli_fetch_assoc($result)): ?>
                                        <tr>
                                            <td><?php echo $serial_no++; ?></td> <!-- Increment serial number -->
                                            <td><?php echo htmlspecialchars($row['application_no']); ?></td>
                                            <td><?php echo htmlspecialchars($row['student_name']); ?></td>
                                            <td><?php echo htmlspecialchars($row['father_name']); ?></td>
                                            <td><?php echo htmlspecialchars($row['aadhaar_no']); ?></td>
                                            <td><?php echo htmlspecialchars($row['district']); ?></td>
                                            <td><?php echo htmlspecialchars($row['state']); ?></td>
                                            <td><a href="<?php echo htmlspecialchars($row['passport_size_photo']); ?>" target="_blank">View Photo</a></td>
                                            <td>
                                                <?php if ($row['pdf_file']): ?>
<a href="uploads/<?php echo htmlspecialchars($row['pdf_file']); ?>" target="_blank" class="btn btn-info btn-sm">View PDF</a>                                                <?php else: ?>
                                                    Not Generated
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo htmlspecialchars($row['status']); ?></td>
                                            <td><?php echo htmlspecialchars($row['fee']); ?></td>
                                            <td><?php echo htmlspecialchars($row['date']); ?></td>
                                        </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!--end page wrapper -->

<!-- Bootstrap JS -->
<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
<script src="../template/ahkweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/ahkweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/ahkweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<!--app JS-->
<script src="../template/ahkweb/assets/js/app.js"></script>

</body>
</html>
