<?php
include('header.php');

// Initialize messages
$message = '';

// Handle PDF upload
if (isset($_POST['upload_pdf'])) {
    $application_no = mysqli_real_escape_string($ahk_conn, $_POST['application_no']);
    $pdf_file = $_FILES['pdf_file']['name'];
    $pdf_temp = $_FILES['pdf_file']['tmp_name'];

    // Move PDF to uploads directory
    if (move_uploaded_file($pdf_temp, "uploads/" . $pdf_file)) {
        // Update application with PDF path and set status to 'Approved'
        $query = "UPDATE authorization_letters SET pdf_file='$pdf_file', status='approved' WHERE application_no='$application_no'";
        if (mysqli_query($ahk_conn, $query)) {
            $message = '<div class="alert alert-success">PDF uploaded successfully and status set to Approved.</div>';
        } else {
            $message = '<div class="alert alert-danger">Failed to update database.</div>';
        }
    } else {
        $message = '<div class="alert alert-danger">Failed to upload file.</div>';
    }
}

// Handle Generate Certificate button
if (isset($_POST['generate_certificate'])) {
    $application_no = mysqli_real_escape_string($ahk_conn, $_POST['application_no']);
    header("Location: letterpdf.php?application_no=" . $application_no);
    exit;
}

// Fetch all applications
$result = mysqli_query($ahk_conn, "SELECT * FROM authorization_letters");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin: User Application Details</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        /* Custom CSS for responsive layout */
        @media (max-width: 768px) {
            .card-body {
                padding: 1rem;
            }
            .card {
                margin-bottom: 1rem;
            }
            .col-md-3, .col-md-12 {
                flex: 0 0 100%;
                max-width: 100%;
            }
        }
    </style>
</head>
<body>

<div class="container mt-5">
    <div class="card shadow-lg p-5 border-0">
        <h2 class="text-center mb-4 font-weight-bold text-primary">Admin: User Application Details</h2>

        <!-- Display message -->
        <?php echo $message; ?>

        <!-- Application Details -->
        <div class="row mb-3">
            <div class="col-12">
                <?php while ($row = mysqli_fetch_assoc($result)): ?>
                    <div class="card mb-4 border-left-primary shadow-sm">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12 col-md-3 mb-3">
                                    <strong>Application No:</strong> <?php echo htmlspecialchars($row['application_no']); ?>
                                </div>
                                <div class="col-12 col-md-3 mb-3">
                                    <strong>Name:</strong> <?php echo htmlspecialchars($row['student_name']); ?>
                                </div>
                                <div class="col-12 col-md-3 mb-3">
                                    <strong>Email:</strong> <?php echo htmlspecialchars($row['email']); ?>
                                </div>
                                <div class="col-12 col-md-3 mb-3">
                                    <strong>Mobile:</strong> <?php echo htmlspecialchars($row['mobile']); ?>
                                </div>
                            </div>

                            <div class="row mt-2">
                                <div class="col-12 col-md-3">
                                    <strong>Aadhaar No:</strong> <?php echo htmlspecialchars($row['aadhaar_no']); ?>
                                </div>
                                <div class="col-12 col-md-3">
                                    <strong>District:</strong> <?php echo htmlspecialchars($row['district']); ?>
                                </div>
                                <div class="col-12 col-md-3">
                                    <strong>State:</strong> <?php echo htmlspecialchars($row['state']); ?>
                                </div>
                                <div class="col-12 col-md-3">
                                    <strong>Fee:</strong> <?php echo htmlspecialchars($row['fee']); ?>
                                </div>
                            </div>

                            <div class="row mt-3">
                                <div class="col-12 col-md-3">
                                    <strong>Date:</strong> <?php echo htmlspecialchars($row['date']); ?>
                                </div>
                                <div class="col-12 col-md-3">
                                    <strong>Status:</strong> 
                                    <span class="badge badge-<?php echo $row['status'] == 'approved' ? 'success' : 'warning'; ?>">
                                        <?php echo ucfirst($row['status']); ?>
                                    </span>
                                </div>
                                <div class="col-12 col-md-3">
                                    <strong>PDF:</strong>
                                    <?php if ($row['pdf_file']): ?>
                                        <a href="uploads/<?php echo htmlspecialchars($row['pdf_file']); ?>" target="_blank" class="btn btn-info btn-sm">View PDF</a>
                                    <?php else: ?>
                                        <span class="text-danger">No PDF Uploaded</span>
                                    <?php endif; ?>
                                </div>
                                <div class="col-12 col-md-3">
                                    <?php if (!$row['pdf_file']): ?>
                                        <form action="" method="POST" enctype="multipart/form-data">
                                            <input type="hidden" name="application_no" value="<?php echo htmlspecialchars($row['application_no']); ?>">
                                            <div class="custom-file">
                                                <input type="file" name="pdf_file" class="custom-file-input" required>
                                                <label class="custom-file-label">Choose file</label>
                                            </div>
                                            <button type="submit" name="upload_pdf" class="btn btn-success btn-sm mt-2">Upload</button>
                                        </form>
                                    <?php else: ?>
                                        <span class="text-success">Already Uploaded</span>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <!-- Generate Certificate button below the upload section -->
                            <div class="row mt-3">
                                <div class="col-12">
                                    <?php if ($row['status'] == 'pending'): ?>
                                        <a href="letterpdf.php?application_no=<?php echo htmlspecialchars($row['application_no']); ?>" class="btn btn-primary btn-sm">Generate Certificate</a>
                                    <?php endif; ?>
                                </div>
                            </div>

                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
        </div>
    </div>
</div>

<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
<script>
    // Show the file name in the custom file input
    document.querySelectorAll('.custom-file-input').forEach(input => {
        input.addEventListener('change', function() {
            var fileName = this.value.split('\\').pop();
            this.nextElementSibling.classList.add('selected');
            this.nextElementSibling.innerHTML = fileName;
        });
    });
</script>

</body>
</html>
