<?php
include('header.php');

// Initialize error and success messages
$error_message = '';
$success_message = '';

// Check if form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Retrieve form data
    $student_name = mysqli_real_escape_string($ahk_conn, $_POST['student_name']);
    $father_name = mysqli_real_escape_string($ahk_conn, $_POST['father_name']);
    $aadhaar_no = mysqli_real_escape_string($ahk_conn, $_POST['aadhaar_no']);
    $district = mysqli_real_escape_string($ahk_conn, $_POST['district']);
    $state = mysqli_real_escape_string($ahk_conn, $_POST['state']);
    $fee = 500;  // Set fee to 1500
    $appliedby = $udata['phone'];
$application_no = "12" . rand(1, 9); // Generate a 3-digit unique application number
    $date = date("Y-m-d H:i:s");

    // Check if user balance is sufficient
    if ($udata['balance'] >= $fee) {
        $nbal = $udata['balance'] - $fee;

        // Update user balance
        $debit = mysqli_query($ahk_conn, "UPDATE users SET balance=balance-$fee WHERE phone='$appliedby'");

        // Log transaction in history
        $updatehistory = mysqli_query($ahk_conn, "INSERT INTO `wallethistory`(`userid`, `amount`, `balance`, `purpose`, `status`, `type`) VALUES ('$appliedby','$fee','$nbal','Authorization Letter Fee','1','Debit')");

        if ($debit && $updatehistory) {
            // Handle file upload
            $targetDirectory = "uploads/";
            $targetFile = $targetDirectory . basename($_FILES['passport_size_photo']['name']);
            $passportSizePhotoPath = mysqli_real_escape_string($ahk_conn, $targetFile);

            if (move_uploaded_file($_FILES['passport_size_photo']['tmp_name'], $targetFile)) {
                // Insert user details into the database
                $submit = mysqli_query($ahk_conn, "INSERT INTO `authorization_letters` (`appliedby`, `application_no`, `student_name`, `father_name`, `aadhaar_no`, `district`, `state`, `passport_size_photo`, `status`, `fee`, `date`) VALUES ('$appliedby', '$application_no', '$student_name', '$father_name', '$aadhaar_no', '$district', '$state', '$passportSizePhotoPath', 'pending', '$fee', '$date')");

                if ($submit) {
                    $success_message = 'Authorization Letter application submitted successfully.';
                } else {
                    $error_message = 'Failed to submit application. Please try again.';
                }
            } else {
                $error_message = 'Failed to upload passport size photo. Please try again.';
            }
        } else {
            $error_message = 'Failed to update balance. Please try again.';
        }
    } else {
        $error_message = 'Insufficient balance to pay the application fee.';
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <!-- Required meta tags and CSS -->
    <title>Authorization Letter Application</title>
    <link rel="stylesheet" href="../template/ahkweb/assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="../template/ahkweb/assets/css/style.css">
</head>
<body>
<!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Authorization Letter Application</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">Authorization Letter Form</li>
                    </ol>
                </nav>
            </div>
        </div>
        <!--end breadcrumb-->
        
        <div class="row">
            <div class="col-xl-10 mx-auto">
                <div class="card border-top border-0 border-4 border-primary">
                    <div class="card-body p-5">
                        <div class="card-title d-flex align-items-center">
                            <div><i class="bx bx-user me-1 font-22 text-primary"></i></div>
                            <h5 class="mb-0 text-primary">Authorization Letter Form</h5>
                        </div>
                        <hr>

                        <!-- Display success or error message -->
                        <?php if ($success_message): ?>
                            <div class="alert alert-success" role="alert">
                                <?php echo $success_message; ?>
                            </div>
                        <?php endif; ?>
                        <?php if ($error_message): ?>
                            <div class="alert alert-danger" role="alert">
                                <?php echo $error_message; ?>
                            </div>
                        <?php endif; ?>

                        <form action="" method="POST" enctype="multipart/form-data" class="row g-3">
                            <!-- Student Name -->
                            <div class="col-md-6">
                                <label for="student_name" class="form-label"> Name:</label>
                                <input type="text" id="student_name" name="student_name" class="form-control" required>
                            </div>

                            <!-- Father Name -->
                            <div class="col-md-6">
                                <label for="father_name" class="form-label">Father Name / Husband Name:</label>
                                <input type="text" id="father_name" name="father_name" class="form-control" required>
                            </div>

                            <!-- Aadhaar Number -->
                            <div class="col-md-6">
                                <label for="aadhaar_no" class="form-label">Aadhaar Number:</label>
                                <input type="text" id="aadhaar_no" name="aadhaar_no" class="form-control" data-inputmask="'mask': '9999 9999 9999'" placeholder="Enter Aadhaar Number" required>
                            </div>

                            <!-- District -->
                            <div class="col-md-6">
                                <label for="district" class="form-label">District:</label>
                                <input type="text" id="district" name="district" class="form-control" required>
                            </div>

                            <!-- State -->
                            <div class="col-md-6">
                                <label for="state" class="form-label">State:</label>
                                <input type="text" id="state" name="state" class="form-control" required>
                            </div>

                            <!-- Passport Size Photo -->
                            <div class="col-md-6">
                                <label for="passport_size_photo" class="form-label">Passport Size Photo:</label>
                                <input type="file" id="passport_size_photo" name="passport_size_photo" class="form-control" accept="image/*" required>
                            </div>

                            <!-- Fee -->
                            <div class="col-12">
                                <label for="fee" class="form-label">Application Fee:</label>
                                <input type="text" id="fee" name="fee" class="form-control" value="₹500" readonly>
                            </div>

                            <!-- Submit Button -->
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary px-5">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!--end page wrapper -->

<!-- Bootstrap JS -->
<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
<script src="../template/ahkweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/ahkweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/ahkweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<!--app JS-->
<script src="../template/ahkweb/assets/js/app.js"></script>

<!-- Inputmask for number -->
<script>
    $(document).ready(function() {
        $('#aadhaar_no').inputmask(); // Masking the Aadhaar number input
    });
</script>

</body>
</html>
