<?php
include('header.php');

// Assuming the user is logged in and their mobile number is stored in the session
$appliedby = $udata['phone']; // Get the appliedby (phone number) from the session

// Fetch application data for the logged-in user
$query = "SELECT application_no, name, registration_no, mobile, state, aadhaar, screenshot, status, fee, date, pdf 
          FROM land_seeding_applications 
          WHERE appliedby = '$appliedby'";
$result = mysqli_query($ahk_conn, $query);

if (!$result) {
    die('Error fetching application data: ' . mysqli_error($ahk_conn));
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Application Status</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f0f8ff;
            color: #333;
            margin: 0;
            padding: 0;
        }
        .header {
            background-color: #4CAF50;
            color: white;
            padding: 15px;
            text-align: center;
        }
        .container {
            padding: 20px;
        }
        h2 {
            color: #4CAF50;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        tr:hover {
            background-color: #ddd;
        }
        .alert {
            padding: 20px;
            background-color: #f44336;
            color: white;
        }
        .btn-download {
            color: white;
            background-color: #4CAF50;
            border: none;
            padding: 8px 16px;
            text-align: center;
            text-decoration: none;
            display: inline-block;
            font-size: 14px;
            margin: 4px 2px;
            cursor: pointer;
            border-radius: 4px;
        }
        .btn-download:hover {
            background-color: #45a049;
        }
        .btn-pending {
            color: white;
            background-color: #f44336;
            border: none;
            padding: 8px 16px;
            text-align: center;
            text-decoration: none;
            display: inline-block;
            font-size: 14px;
            margin: 4px 2px;
            cursor: pointer;
            border-radius: 4px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Application Status</h1>
    </div>
    <div class="container">
        <h2>Your Applications</h2>

        <?php if (mysqli_num_rows($result) > 0): ?>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Application No.</th>
                        <th>Name</th>
                        <th>Registration No.</th>
                        <th>Mobile</th>
                        <th>State</th>
                         <th>AAdhaar No</th>
                        <th>Screenshot</th>
                        <th>Status</th>
                        
                        <th>Date Applied</th>
                        <th>PDF</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = mysqli_fetch_assoc($result)): ?>
                        <tr>
                            <td><?php echo $row['application_no']; ?></td>
                            <td><?php echo $row['name']; ?></td>
                            <td><?php echo $row['registration_no']; ?></td>
                            <td><?php echo $row['mobile']; ?></td>
                            <td><?php echo $row['state']; ?></td>
                            <td><?php echo $row['aadhaar']; ?></td>
                            <td>
                                <a href="uploads/<?php echo $row['screenshot']; ?>" target="_blank">View Screenshot</a>
                            </td>
                            <td><?php echo ucfirst($row['status']); ?></td>
                           
                            <td><?php echo date('d-m-Y H:i:s', strtotime($row['date'])); ?></td>
                            <td>
                                <?php if ($row['pdf']): ?>
                                    <a href="uploads/<?php echo $row['pdf']; ?>" target="_blank">View PDF</a>
                                <?php else: ?>
                                    No PDF
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if ($row['status'] == 'approved' && $row['pdf']): ?>
                                    <a href="uploads/<?php echo $row['pdf']; ?>" class="btn-download" target="_blank">Download PDF</a>
                                <?php elseif ($row['status'] == 'pending'): ?>
                                    <button class="btn-pending" disabled>Data Not Approved Yet</button>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        <?php else: ?>
            <div class="alert alert-warning" role="alert">
                No applications found.
            </div>
        <?php endif; ?>

    </div>
    <!-- Include your JS files here -->
</body>
</html>

<?php 
include('footer.php');
?>
