<?php
include('header.php');

// Initialize error and success messages
$error_message = '';
$success_message = '';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Retrieve and sanitize form data
    $name = mysqli_real_escape_string($ahk_conn, $_POST['name']);
    $registration_no = mysqli_real_escape_string($ahk_conn, $_POST['registration_no']);
    $mobile = mysqli_real_escape_string($ahk_conn, $_POST['mobile']);
    $aadhaar = mysqli_real_escape_string($ahk_conn, $_POST['aadhaar']); // Sanitize Aadhaar input
    $state = mysqli_real_escape_string($ahk_conn, $_POST['state']);
    $fee = 1000;  // Set fee to 1000
    $appliedby = $udata['phone'];  // Assuming user phone number from session
    $application_no = "LS" . rand(10000000, 99999999); // Generate unique application number
    $date = date("Y-m-d H:i:s");

    // File upload handling
    $screenshot = $_FILES['screenshot']['name'];
    $screenshot_temp = $_FILES['screenshot']['tmp_name'];
    $screenshot_folder = "uploads/" . $screenshot;
    
    // Move the uploaded file to the specified directory
    if (!move_uploaded_file($screenshot_temp, $screenshot_folder)) {
        die('Error uploading file.');
    }

    // Check if user balance is sufficient
    if ($udata['balance'] >= $fee) {
        $nbal = $udata['balance'] - $fee;

        // Update user balance
        $debit_query = "UPDATE users SET balance=balance-$fee WHERE phone='$appliedby'";
        if (!mysqli_query($ahk_conn, $debit_query)) {
            die('Error updating balance: ' . mysqli_error($ahk_conn));
        }

        // Insert application
        $insert_query = "INSERT INTO `land_seeding_applications` (`appliedby`, `application_no`, `name`, `registration_no`, `mobile`, `aadhaar`, `state`, `screenshot`, `status`, `fee`, `date`) 
                         VALUES ('$appliedby', '$application_no', '$name', '$registration_no', '$mobile', '$aadhaar', '$state', '$screenshot', 'pending', '$fee', '$date')";
        if (mysqli_query($ahk_conn, $insert_query)) {
            $success_message = 'Application submitted successfully.';
        } else {
            die('Error submitting application: ' . mysqli_error($ahk_conn));
        }
    } else {
        $error_message = 'Insufficient balance. Please recharge your wallet.';
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <!-- Required meta tags and CSS -->
</head>
<body>
<!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Land Seeding Application</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">Land Seeding Application Form</li>
                    </ol>
                </nav>
            </div>
        </div>
        <!--end breadcrumb-->
        
        <div class="row">
            <div class="col-xl-10 mx-auto">
                <div class="card border-top border-0 border-4 border-primary">
                    <div class="card-body p-5">
                        <div class="card-title d-flex align-items-center">
                            <div><i class="bx bx-user me-1 font-22 text-primary"></i></div>
                            <h5 class="mb-0 text-primary">Land Seeding Application Form</h5>
                        </div>
                        <hr>

                        <!-- Display success or error message -->
                        <?php if ($success_message): ?>
                            <div class="alert alert-success" role="alert">
                                <?php echo $success_message; ?>
                            </div>
                        <?php endif; ?>
                        <?php if ($error_message): ?>
                            <div class="alert alert-danger" role="alert">
                                <?php echo $error_message; ?>
                            </div>
                        <?php endif; ?>

                        <form action="" method="POST" enctype="multipart/form-data" class="row g-3">
                            <!-- Name -->
                            <div class="col-md-6">
                                <label for="name" class="form-label">Name:</label>
                                <input type="text" id="name" name="name" class="form-control" required>
                            </div>

                            <!-- Registration Number -->
                            <div class="col-md-6">
                                <label for="registration_no" class="form-label">Registration Number:</label>
                                <input type="text" id="registration_no" name="registration_no" class="form-control" required>
                            </div>

                            <!-- Mobile Number -->
                            <div class="col-md-6">
                                <label for="mobile" class="form-label">Mobile Number:</label>
                                <input type="text" id="mobile" name="mobile" class="form-control" data-inputmask="'mask': '9999999999'" placeholder="Enter 10-digit mobile number" required>
                                <small>Enter a valid 10-digit mobile number.</small>
                            </div>

                            <!-- Aadhaar Number -->
                            <div class="col-md-6">
                                <label for="aadhaar" class="form-label">Aadhaar Number:</label>
                                <input type="text" id="aadhaar" name="aadhaar" class="form-control" data-inputmask="'mask': '999999999999'" placeholder="Enter 12-digit Aadhaar number" required>
                                <small>Enter a valid 12-digit Aadhaar number.</small>
                            </div>

                            <!-- State -->
                            <div class="col-md-6">
                                <label for="state" class="form-label">State:</label>
                                <select id="state" name="state" class="form-select" required>
                                    <option value="UP">UP</option>
                                    <option value="BIHAR">BIHAR</option>
                                    <option value="JHARKHAND">JHARKHAND</option>
                                </select>
                            </div>

                            <!-- Upload Screenshot -->
                            <div class="col-md-6">
                                <label for="screenshot" class="form-label">Upload Screenshot:</label>
                                <input type="file" id="screenshot" name="screenshot" class="form-control" required>
                            </div>

                            <!-- Fee -->
                            <div class="col-12">
                                <label for="fee" class="form-label">Application Fee:</label>
                                <input type="text" id="fee" name="fee" class="form-control" value="₹1000" readonly>
                            </div>

                            <!-- Submit Button -->
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary px-5">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!--end page wrapper -->

<?php 
include('footer.php');
?>

<!-- Bootstrap JS -->
<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
</body>
</html>
