<?php
include('header.php');

// Fetch all applications from the database
$query = "SELECT id, application_no, name, registration_no, mobile, state, aadhaar, screenshot, status, fee, date, pdf 
          FROM land_seeding_applications";
$result = mysqli_query($ahk_conn, $query);

if (!$result) {
    die('Error fetching applications data: ' . mysqli_error($ahk_conn));
}

// Handle form submissions (Approve/Reject/Upload PDF)
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $applicationId = $_POST['application_id'];
    $status = $_POST['status'];

    // Handle PDF upload
    $pdfName = '';
    if (!empty($_FILES['pdf']['name'])) {
        $pdfName = 'application_' . $applicationId . '_' . time() . '.pdf';
        $pdfPath = 'uploads/' . $pdfName;
        if (move_uploaded_file($_FILES['pdf']['tmp_name'], $pdfPath)) {
            // Update status and pdf in the database
            $updateQuery = "UPDATE land_seeding_applications SET status='$status', pdf='$pdfName' WHERE id='$applicationId'";
            if (mysqli_query($ahk_conn, $updateQuery)) {
                echo "<script>
                        Swal.fire({
                            icon: 'success',
                            title: 'Updated Successfully',
                            text: 'The application has been updated successfully.',
                            showConfirmButton: true,
                            timer: 3000
                        });
                      </script>";
            } else {
                echo "<script>
                        Swal.fire({
                            icon: 'error',
                            title: 'Update Failed',
                            text: 'Error updating the application: " . mysqli_error($ahk_conn) . "',
                            showConfirmButton: true,
                            timer: 3000
                        });
                      </script>";
            }
        } else {
            echo "<script>
                    Swal.fire({
                        icon: 'error',
                        title: 'Upload Failed',
                        text: 'Error uploading the PDF.',
                        showConfirmButton: true,
                        timer: 3000
                    });
                  </script>";
        }
    } else {
        // Update status without uploading a new PDF
        $updateQuery = "UPDATE land_seeding_applications SET status='$status' WHERE id='$applicationId'";
        if (mysqli_query($ahk_conn, $updateQuery)) {
            echo "<script>
                    Swal.fire({
                        icon: 'success',
                        title: 'Updated Successfully',
                        text: 'The application status has been updated successfully.',
                        showConfirmButton: true,
                        timer: 3000
                    });
                  </script>";
        } else {
            echo "<script>
                    Swal.fire({
                        icon: 'error',
                        title: 'Update Failed',
                        text: 'Error updating the application: " . mysqli_error($ahk_conn) . "',
                        showConfirmButton: true,
                        timer: 3000
                    });
                  </script>";
        }
    }
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - Manage Applications</title>
    <style>
        /* Include the same CSS styles from previous code */
    </style>
    <!-- Include SweetAlert CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
</head>
<body>
    <div class="header">
        <h1>Admin Panel - Manage Applications</h1>
    </div>
    <div class="container">
        <h2>All Applications</h2>

        <?php if (mysqli_num_rows($result) > 0): ?>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Application No.</th>
                        <th>Name</th>
                        <th>Registration No.</th>
                        <th>Mobile</th>
                        <th>State</th>
                        <th>Screenshot</th>
                        <th>Status</th>
                        <th>Aadhaar No</th>
                        <th>Date Applied</th>
                        <th>PDF</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = mysqli_fetch_assoc($result)): ?>
                        <tr>
                            <td><?php echo $row['application_no']; ?></td>
                            <td><?php echo $row['name']; ?></td>
                            <td><?php echo $row['registration_no']; ?></td>
                            <td><?php echo $row['mobile']; ?></td>
                            <td><?php echo $row['state']; ?></td>
                            <td><?php echo $row['aadhaar']; ?></td>
                            <td>
                                <a href="uploads/<?php echo $row['screenshot']; ?>" target="_blank">View Screenshot</a>
                            </td>
                            <td><?php echo ucfirst($row['status']); ?></td>
                            <td><?php echo date('d-m-Y H:i:s', strtotime($row['date'])); ?></td>
                            <td>
                                <?php if ($row['pdf']): ?>
                                    <a href="uploads/<?php echo $row['pdf']; ?>" target="_blank">View PDF</a>
                                <?php else: ?>
                                    No PDF
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if ($row['status'] == 'approved'): ?>
                                    <?php if ($row['pdf']): ?>
                                        Already Uploaded
                                    <?php else: ?>
                                        PDF Required
                                    <?php endif; ?>
                                <?php else: ?>
                                    <form method="post" enctype="multipart/form-data" class="upload-form">
                                        <input type="hidden" name="application_id" value="<?php echo $row['id']; ?>">
                                        <select name="status">
                                            <option value="pending" <?php echo $row['status'] == 'pending' ? 'selected' : ''; ?>>Pending</option>
                                            <option value="approved" <?php echo $row['status'] == 'approved' ? 'selected' : ''; ?>>Approved</option>
                                            <option value="rejected" <?php echo $row['status'] == 'rejected' ? 'selected' : ''; ?>>Rejected</option>
                                        </select>
                                        <input type="file" name="pdf" <?php echo $row['status'] == 'approved' ? 'disabled' : ''; ?>>
                                        <button type="submit" <?php echo $row['status'] == 'approved' ? 'disabled' : ''; ?>>Update</button>
                                    </form>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        <?php else: ?>
            <div class="alert alert-warning" role="alert">
                No applications found.
            </div>
        <?php endif; ?>

    </div>
    <!-- Include SweetAlert JS -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.all.min.js"></script>
</body>
</html>

<?php 
include('footer.php');
?>
