<?php
include('header.php');
// Initialize error and success messages
$error_message = '';
$success_message = '';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Retrieve and sanitize form data
    $applicant_name = mysqli_real_escape_string($ahk_conn, $_POST['name']);
    $gender = mysqli_real_escape_string($ahk_conn, $_POST['gender']);
    $relationship = mysqli_real_escape_string($ahk_conn, $_POST['relationship']);
    $relative_name = mysqli_real_escape_string($ahk_conn, $_POST['relative_name']);
    $address1 = mysqli_real_escape_string($ahk_conn, $_POST['address1']);
    $address2 = mysqli_real_escape_string($ahk_conn, $_POST['address2']);
    $state = mysqli_real_escape_string($ahk_conn, $_POST['state']);
    $district = mysqli_real_escape_string($ahk_conn, $_POST['district']);
    $sub_division = mysqli_real_escape_string($ahk_conn, $_POST['sub_division']);
    $circle_office = mysqli_real_escape_string($ahk_conn, $_POST['circle_office']);
    $village_town = mysqli_real_escape_string($ahk_conn, $_POST['village_town']);
    $police_station = mysqli_real_escape_string($ahk_conn, $_POST['police_station']);
    $post_office = mysqli_real_escape_string($ahk_conn, $_POST['post_office']);
    $mobile_number = mysqli_real_escape_string($ahk_conn, $_POST['mobile_number']);
    $pin_code = mysqli_real_escape_string($ahk_conn, $_POST['pin_code']);
    $application_fee = 100; // Set fee to 100
    $appliedby = $udata['phone']; // Assuming user phone number from session
    $application_no = "KC" . rand(10000000, 99999999); // Generate unique application number
    $date = date("Y-m-d H:i:s"); // Get current date and time

    // File upload handling
    $uploads_dir = "uploads/"; // Set the uploads directory
    $file_names = [
        'address_proof' => $_FILES['address_proof']['name'],
        'identity_proof' => $_FILES['identity_proof']['name'],
        'relationship_proof' => $_FILES['relationship_proof']['name'],
        'signature' => $_FILES['signature']['name'],
    ];

    // Move uploaded files to the specified directory
    foreach ($file_names as $key => $file_name) {
        if ($_FILES[$key]['error'] == UPLOAD_ERR_OK) {
            move_uploaded_file($_FILES[$key]['tmp_name'], $uploads_dir . $file_name);
        } else {
            $error_message = "Error uploading file: " . $_FILES[$key]['error'];
            break; // Stop processing if there's an error
        }
    }

    // Check if user balance is sufficient
    if (empty($error_message) && $udata['balance'] >= $application_fee) {
        $nbal = $udata['balance'] - $application_fee;

        // Update user balance
        $debit_query = "UPDATE users SET balance=$nbal WHERE phone='$appliedby'";
        if (mysqli_query($ahk_conn, $debit_query)) {
            // Insert the application details into the database
            $query = "INSERT INTO kin_certificates (applicant_name, gender, relationship, relative_name, address1, address2, state, district, sub_division, circle_office, village_town, police_station, post_office, mobile_number, pin_code, application_fee, applied_by, application_no, date, address_proof, identity_proof, relationship_proof, signature) 
                      VALUES ('$applicant_name', '$gender', '$relationship', '$relative_name', '$address1', '$address2', '$state', '$district', '$sub_division', '$circle_office', '$village_town', '$police_station', '$post_office', '$mobile_number', '$pin_code', '$application_fee', '$appliedby', '$application_no', '$date', '{$file_names['address_proof']}', '{$file_names['identity_proof']}', '{$file_names['relationship_proof']}', '{$file_names['signature']}')";

            if (mysqli_query($ahk_conn, $query)) {
                $success_message = "Kin Certificate application submitted successfully.";
            } else {
                $error_message = "Error inserting application: " . mysqli_error($ahk_conn);
            }
        } else {
            $error_message = "Error updating balance: " . mysqli_error($ahk_conn);
        }
    } else {
        $error_message = "Insufficient balance to process the application.";
    }
}
?>

<!-- Display success or error message -->
<?php if (!empty($success_message)) : ?>
    <div class="alert alert-success"><?= $success_message; ?></div>
<?php endif; ?>

<?php if (!empty($error_message)) : ?>
    <div class="alert alert-danger"><?= $error_message; ?></div>
<?php endif; ?>

<!-- Start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <div class="row">
            <div class="col-xl-10 mx-auto">
                <h6 class="mb-0 text-uppercase">Kin Certificate Apply</h6>
                <hr/>
                <div class="card border-top border-0 border-4 border-primary">
                    <div class="card-body p-5">
                        <div class="card-title d-flex align-items-center">
                            <div><i class="bx bxs-id-card me-1 font-22 text-primary"></i></div>
                            <h5 class="mb-0 text-primary">Enter Kin Detail</h5>
                        </div>
                        <hr>
                        <form action="" method="POST" class="row g-3" enctype="multipart/form-data">
                            <!-- Applicant's Name -->
                            <div class="col-md-3">
                                <label for="inputName" class="form-label">Applicant’s Name</label>
                                <input name="name" type="text" placeholder="Name As Per Aadhaar" class="form-control" id="inputName" required>
                            </div>
                            <!-- Applicant's Gender -->
                            <div class="col-md-3">
                                <label for="inputGender" class="form-label">Applicant's Gender</label>
                                <input name="gender" type="text" placeholder="Applicant's Gender" class="form-control" id="inputGender" required>
                            </div>
                            <!-- Relationship -->
                            <div class="col-md-3">
                                <label for="inputRelationship" class="form-label">Relationship</label>
                                <input name="relationship" type="text" placeholder="Relationship" class="form-control" id="inputRelationship" required>
                            </div>
                            <!-- Relative's Name -->
                            <div class="col-md-3">
                                <label for="inputRelativeName" class="form-label">Relative's Name</label>
                                <input name="relative_name" type="text" placeholder="Relative's Name" class="form-control" id="inputRelativeName" required>
                            </div>
                            <!-- Address Line 1 -->
                            <div class="col-md-3">
                                <label for="inputAddress1" class="form-label">Address Line 1</label>
                                <input name="address1" type="text" placeholder="Address Line 1" class="form-control" id="inputAddress1" required>
                            </div>
                            <!-- Address Line 2 -->
                            <div class="col-md-3">
                                <label for="inputAddress2" class="form-label">Address Line 2</label>
                                <input name="address2" type="text" placeholder="Address Line 2" class="form-control" id="inputAddress2">
                            </div>
                            <!-- State -->
                            <div class="col-md-3">
                                <label for="inputState" class="form-label">State</label>
                                <input name="state" type="text" placeholder="State" class="form-control" id="inputState" required>
                            </div>
                            <!-- District -->
                            <div class="col-md-3">
                                <label for="inputDistrict" class="form-label">District</label>
                                <input name="district" type="text" placeholder="District" class="form-control" id="inputDistrict" required>
                            </div>
                            <!-- Sub Division -->
                            <div class="col-md-3">
                                <label for="inputSubDivision" class="form-label">Sub Division</label>
                                <input name="sub_division" type="text" placeholder="Sub Division" class="form-control" id="inputSubDivision" required>
                            </div>
                            <!-- Circle Office -->
                            <div class="col-md-3">
                                <label for="inputCircleOffice" class="form-label">Circle Office</label>
                                <input name="circle_office" type="text" placeholder="Circle Office" class="form-control" id="inputCircleOffice" required>
                            </div>
                            <!-- Village/Town -->
                            <div class="col-md-3">
                                <label for="inputVillageTown" class="form-label">Village/Town</label>
                                <input name="village_town" type="text" placeholder="Village/Town" class="form-control" id="inputVillageTown" required>
                            </div>
                            <!-- Police Station -->
                            <div class="col-md-3">
                                <label for="inputPoliceStation" class="form-label">Police Station</label>
                                <input name="police_station" type="text" placeholder="Police Station" class="form-control" id="inputPoliceStation" required>
                            </div>
                            <!-- Post Office -->
                            <div class="col-md-3">
                                <label for="inputPostOffice" class="form-label">Post Office</label>
                                <input name="post_office" type="text" placeholder="Post Office" class="form-control" id="inputPostOffice" required>
                            </div>
                            <!-- Mobile Number -->
                            <div class="col-md-3">
                                <label for="inputMobile" class="form-label">Mobile Number</label>
                                <input name="mobile_number" type="text" placeholder="Mobile Number" class="form-control" id="inputMobile" required>
                            </div>
                            <!-- Pin Code -->
                            <div class="col-md-3">
                                <label for="inputPinCode" class="form-label">Pin Code</label>
                                <input name="pin_code" type="text" placeholder="Pin Code" class="form-control" id="inputPinCode" required>
                            </div>
                            <!-- Address Proof -->
                            <div class="col-md-3">
                                <label for="addressProof" class="form-label">Upload Address Proof</label>
                                <input name="address_proof" type="file" class="form-control" id="addressProof" required>
                            </div>
                            <!-- Identity Proof -->
                            <div class="col-md-3">
                                <label for="identityProof" class="form-label">Upload Identity Proof</label>
                                <input name="identity_proof" type="file" class="form-control" id="identityProof" required>
                            </div>
                            <!-- Relationship Proof -->
                            <div class="col-md-3">
                                <label for="relationshipProof" class="form-label">Upload Relationship Proof</label>
                                <input name="relationship_proof" type="file" class="form-control" id="relationshipProof" required>
                            </div>
                            <!-- Signature -->
                            <div class="col-md-3">
                                <label for="signature" class="form-label">Upload Signature</label>
                                <input name="signature" type="file" class="form-control" id="signature" required>
                            </div>
                            <!-- Submit Button -->
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary">Submit Application</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include('../template/ahkweb/footer.php'); ?>
