<?php
include('header.php');

// Check if form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'];
    $status = $_POST['status'];
    
    // Handle file upload
    if (isset($_FILES['admin_file']) && $_FILES['admin_file']['error'] === 0) {
        $file_name = $_FILES['admin_file']['name'];
        $file_tmp = $_FILES['admin_file']['tmp_name'];
        $upload_dir = 'uploads/';
        $file_path = $upload_dir . basename($file_name);
        
        // Move the uploaded file to the 'uploads' directory
        if (move_uploaded_file($file_tmp, $file_path)) {
            // Update status and admin file path in the database
            $sql_update = "UPDATE income_certificates SET status = '$status', admin_file = '$file_name' WHERE id = '$id'";
            mysqli_query($ahk_conn, $sql_update);
        } else {
            echo "File upload failed.";
        }
    } else {
        // If no file uploaded, only update status
        $sql_update = "UPDATE income_certificates SET status = '$status' WHERE id = '$id'";
        mysqli_query($ahk_conn, $sql_update);
    }
}

// Fetch income certificates from the database
$sql = "SELECT * FROM `income_certificates` ORDER BY id DESC";
$result = mysqli_query($ahk_conn, $sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Income Certificate Admin Panel</title>
    <link rel="stylesheet" href="path_to_your_css/bootstrap.min.css"> <!-- Bootstrap CSS -->
    <style>
        .card {
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="container mt-5">
        <h2 class="text-center">Income Certificate Admin Panel</h2>
        <div class="row">
            <?php while ($row = mysqli_fetch_assoc($result)) { ?>
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title"><?= htmlspecialchars($row['applicant_name']) ?></h5>
                            <p><strong>Name As Per Aadhaar:</strong> <?= htmlspecialchars($row['name_as_per_aadhaar']) ?></p>
                            <p><strong>Gender:</strong> <?= htmlspecialchars($row['gender']) ?></p>
                            <p><strong>Relationship:</strong> <?= htmlspecialchars($row['relationship']) ?></p>
                            <p><strong>Relative's Name:</strong> <?= htmlspecialchars($row['relative_name']) ?></p>
                            <p><strong>Occupation:</strong> <?= htmlspecialchars($row['occupation']) ?></p>
                            <p><strong>Total Income:</strong> <?= htmlspecialchars($row['total_income']) ?></p>
                            <p><strong>Status:</strong> <?= htmlspecialchars($row['status']) ?></p>
                            
                            <!-- Admin file upload and status update form -->
                            <form action="" method="post" enctype="multipart/form-data">
                                <input type="hidden" name="id" value="<?= $row['id'] ?>">
                                
                                <div class="mb-2">
                                    <label for="admin_file_<?= $row['id'] ?>">Upload Admin File:</label>
                                    <input type="file" name="admin_file" id="admin_file_<?= $row['id'] ?>" class="form-control">
                                </div>
                                
                                <div class="mb-2">
                                    <select name="status" class="form-control">
                                        <option value="approved" <?= ($row['status'] == 'approved') ? 'selected' : '' ?>>Approved</option>
                                        <option value="pending" <?= ($row['status'] == 'pending') ? 'selected' : '' ?>>Pending</option>
                                    </select>
                                </div>
                                
                                <button type="submit" class="btn btn-primary">Update Status</button>
                            </form>
                            
                            <hr>
                            <h6>Uploaded Documents:</h6>
                            <p>
                                <?php if (!empty($row['address_proof'])) { ?>
                                    <a href="uploads/<?= $row['address_proof'] ?>" target="_blank">Address Proof</a>
                                <?php } else { ?>
                                    Address Proof: No file chosen
                                <?php } ?>
                            </p>
                            <p>
                                <?php if (!empty($row['identity_proof'])) { ?>
                                    <a href="uploads/<?= $row['identity_proof'] ?>" target="_blank">Identity Proof</a>
                                <?php } else { ?>
                                    Identity Proof: No file chosen
                                <?php } ?>
                            </p>
                            <p>
                                <?php if (!empty($row['land_certificate'])) { ?>
                                    <a href="uploads/<?= $row['land_certificate'] ?>" target="_blank">Land Certificate</a>
                                <?php } else { ?>
                                    Land Certificate: No file chosen
                                <?php } ?>
                            </p>
                            <p>
                                <?php if (!empty($row['salary_slip'])) { ?>
                                    <a href="uploads/<?= $row['salary_slip'] ?>" target="_blank">Salary Slip</a>
                                <?php } else { ?>
                                    Salary Slip: No file chosen
                                <?php } ?>
                            </p>
                            <p>
                                <?php if (!empty($row['other_document'])) { ?>
                                    <a href="uploads/<?= $row['other_document'] ?>" target="_blank">Other Document</a>
                                <?php } else { ?>
                                    Other Document: No file chosen
                                <?php } ?>
                            </p>
                            <p>
                                <?php if (!empty($row['signature'])) { ?>
                                    <a href="uploads/<?= $row['signature'] ?>" target="_blank">Signature</a>
                                <?php } else { ?>
                                    Signature: No file chosen
                                <?php } ?>
                            </p>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>

    <script src="path_to_your_js/bootstrap.min.js"></script> <!-- Bootstrap JS -->
</body>
</html>
