<?php
include('header.php');

// Initialize error and success messages
$error_message = '';
$success_message = '';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Retrieve and sanitize form data
    $applicant_name = mysqli_real_escape_string($ahk_conn, $_POST['name']);
    $gender = mysqli_real_escape_string($ahk_conn, $_POST['gender']);
    $relationship = mysqli_real_escape_string($ahk_conn, $_POST['relationship']);
    $relative_name = mysqli_real_escape_string($ahk_conn, $_POST['relative_name']);
    $income_source = mysqli_real_escape_string($ahk_conn, $_POST['income_source']);
    $occupation = mysqli_real_escape_string($ahk_conn, $_POST['occupation']);
    $total_income = mysqli_real_escape_string($ahk_conn, $_POST['total_income']);
    $address1 = mysqli_real_escape_string($ahk_conn, $_POST['address1']);
    $address2 = mysqli_real_escape_string($ahk_conn, $_POST['address2']);
    $state = mysqli_real_escape_string($ahk_conn, $_POST['state']);
    $district = mysqli_real_escape_string($ahk_conn, $_POST['district']);
    $sub_division = mysqli_real_escape_string($ahk_conn, $_POST['sub_division']);
    $circle_office = mysqli_real_escape_string($ahk_conn, $_POST['circle_office']);
    $village_town = mysqli_real_escape_string($ahk_conn, $_POST['village_town']);
    $police_station = mysqli_real_escape_string($ahk_conn, $_POST['police_station']);
    $post_office = mysqli_real_escape_string($ahk_conn, $_POST['post_office']);
    $mobile_number = mysqli_real_escape_string($ahk_conn, $_POST['mobile_number']);
    $pin_code = mysqli_real_escape_string($ahk_conn, $_POST['pin_code']);
    $application_fee = 100; // Set fee to 100
    $appliedby = $udata['phone']; // Assuming user phone number from session
    $application_no = "LS" . rand(10000000, 99999999); // Generate unique application number
    $date = date("Y-m-d H:i:s"); // Get current date and time

    // File upload handling
    $uploads_dir = "uploads/"; // Set the uploads directory
    $file_names = [
        'address_proof' => $_FILES['address_proof']['name'],
        'identity_proof' => $_FILES['identity_proof']['name'],
        'land_certificate' => $_FILES['land_certificate']['name'],
        'salary_slip' => $_FILES['salary_slip']['name'],
        'other_document' => $_FILES['other_document']['name'],
        'signature' => $_FILES['signature']['name'],
    ];

    // Move uploaded files to the specified directory
    foreach ($file_names as $key => $file_name) {
        if ($_FILES[$key]['error'] == UPLOAD_ERR_OK) {
            move_uploaded_file($_FILES[$key]['tmp_name'], $uploads_dir . $file_name);
        } else {
            $error_message = "Error uploading file: " . $_FILES[$key]['error'];
            break; // Stop processing if there's an error
        }
    }

    // Check if user balance is sufficient
    if (empty($error_message) && $udata['balance'] >= $application_fee) {
        $nbal = $udata['balance'] - $application_fee;

        // Update user balance
        $debit_query = "UPDATE users SET balance=$nbal WHERE phone='$appliedby'";
        if (mysqli_query($ahk_conn, $debit_query)) {
            // Insert the application details into the database
            $query = "INSERT INTO income_certificates (applicant_name, gender, relationship, relative_name, income_source, occupation, total_income, address1, address2, state, district, sub_division, circle_office, village_town, police_station, post_office, mobile_number, pin_code, application_fee, applied_by, application_no, date, address_proof, identity_proof, land_certificate, salary_slip, other_document, signature) 
                      VALUES ('$applicant_name', '$gender', '$relationship', '$relative_name', '$income_source', '$occupation', '$total_income', '$address1', '$address2', '$state', '$district', '$sub_division', '$circle_office', '$village_town', '$police_station', '$post_office', '$mobile_number', '$pin_code', '$application_fee', '$appliedby', '$application_no', '$date', '{$file_names['address_proof']}', '{$file_names['identity_proof']}', '{$file_names['land_certificate']}', '{$file_names['salary_slip']}', '{$file_names['other_document']}', '{$file_names['signature']}')";

            if (mysqli_query($ahk_conn, $query)) {
                $success_message = "Income Certificate application submitted successfully.";
            } else {
                $error_message = "Error inserting application: " . mysqli_error($ahk_conn);
            }
        } else {
            $error_message = "Error updating balance: " . mysqli_error($ahk_conn);
        }
    } else {
        $error_message = "Insufficient balance to process the application.";
    }
}
?>

<!-- Display success or error message -->
<?php if (!empty($success_message)) : ?>
    <div class="alert alert-success"><?= $success_message; ?></div>
<?php endif; ?>

<?php if (!empty($error_message)) : ?>
    <div class="alert alert-danger"><?= $error_message; ?></div>
<?php endif; ?>


<!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <div class="row">
            <div class="col-xl-10 mx-auto">
                <h6 class="mb-0 text-uppercase">GST Apply</h6>
                <hr/>
                <div class="card border-top border-0 border-4 border-primary">
                    <div class="card-body p-5">
                        <div class="card-title d-flex align-items-center">
                            <div><i class="bx bxs-id-card me-1 font-22 text-primary"></i></div>
                            <h5 class="mb-0 text-primary">Enter Customer Detail</h5>
                        </div>
                        <hr>
                        <form action="" method="POST" class="row g-3" enctype="multipart/form-data">

                            <!-- Applicant's Name -->
                            <div class="col-md-3">
                                <label for="inputName" class="form-label">Applicant’s Name (আববদনকাৰীৰ নাম)</label>
                                <input name="name" type="text" placeholder="Name As Per Aadhaar" class="form-control" id="inputName" required>
                            </div>
                            <!-- Applicant's Gender -->
                            <div class="col-md-3">
                                <label for="inputGender" class="form-label">Applicant's Gender (চলিংগ)</label>
                                <input name="gender" type="text" placeholder="Applicant's Gender" class="form-control" id="inputGender" required>
                            </div>
                            <!-- Relationship -->
                            <div class="col-md-3">
                                <label for="inputRelationship" class="form-label">Relationship (সম্পকক)</label>
                                <input name="relationship" type="text" placeholder="Relationship" class="form-control" id="inputRelationship" required>
                            </div>
                            <!-- Relative's Name -->
                            <div class="col-md-3">
                                <label for="inputRelativeName" class="form-label">Relative's Name (সম্পকীয়ৰ নাম)</label>
                                <input name="relative_name" type="text" placeholder="Relative's Name" class="form-control" id="inputRelativeName" required>
                            </div>
                            <!-- Source of Income -->
                            <div class="col-md-3">
                                <label for="inputIncomeSource" class="form-label">Source of Income (উপাৰ্ক নৰ উৎস)</label>
                                <input name="income_source" type="text" placeholder="Income Source" class="form-control" id="inputIncomeSource" required>
                            </div>
                            <!-- Occupation -->
                            <div class="col-md-3">
                                <label for="inputOccupation" class="form-label">Occupation (বৃচি)</label>
                                <input name="occupation" type="text" placeholder="Occupation" class="form-control" id="inputOccupation" required>
                            </div>
                            <!-- Total Income -->
                            <div class="col-md-3">
                                <label for="inputTotalIncome" class="form-label">Total Income (মুঠ উপাৰ্ক ন)</label>
                                <input name="total_income" type="text" placeholder="Total Income" class="form-control" id="inputTotalIncome" required>
                            </div>
                            <!-- Address Line 1 -->
                            <div class="col-md-3">
                                <label for="inputAddress1" class="form-label">Address Line 1 (ঠিকনাৰ প্রথ্ম শাৰী)</label>
                                <input name="address1" type="text" placeholder="Address Line 1" class="form-control" id="inputAddress1" required>
                            </div>
                            <!-- Address Line 2 -->
                            <div class="col-md-3">
                                <label for="inputAddress2" class="form-label">Address Line 2 (ঠিকনাৰ দ্বিতীয় শাৰী)</label>
                                <input name="address2" type="text" placeholder="Address Line 2" class="form-control" id="inputAddress2">
                            </div>
                            <!-- State -->
                            <div class="col-md-3">
                                <label for="inputState" class="form-label">State (ৰাজ্য)</label>
                                <input name="state" type="text" placeholder="State" class="form-control" id="inputState" required>
                            </div>
                            <!-- District -->
                            <div class="col-md-3">
                                <label for="inputDistrict" class="form-label">District (জিলা)</label>
                                <input name="district" type="text" placeholder="District" class="form-control" id="inputDistrict" required>
                            </div>
                            <!-- Sub Division -->
                            <div class="col-md-3">
                                <label for="inputSubDivision" class="form-label">Sub Division (উপ-বিভাগ)</label>
                                <input name="sub_division" type="text" placeholder="Sub Division" class="form-control" id="inputSubDivision" required>
                            </div>
                            <!-- Circle Office -->
                            <div class="col-md-3">
                                <label for="inputCircleOffice" class="form-label">Circle Office (চকাৰ কাৰ্যালয়)</label>
                                <input name="circle_office" type="text" placeholder="Circle Office" class="form-control" id="inputCircleOffice" required>
                            </div>
                            <!-- Village/Town -->
                            <div class="col-md-3">
                                <label for="inputVillageTown" class="form-label">Village/Town (গাঁও/শহৰ)</label>
                                <input name="village_town" type="text" placeholder="Village/Town" class="form-control" id="inputVillageTown" required>
                            </div>
                            <!-- Police Station -->
                            <div class="col-md-3">
                                <label for="inputPoliceStation" class="form-label">Police Station (পুলিশ থান)</label>
                                <input name="police_station" type="text" placeholder="Police Station" class="form-control" id="inputPoliceStation" required>
                            </div>
                            <!-- Post Office -->
                            <div class="col-md-3">
                                <label for="inputPostOffice" class="form-label">Post Office (পষ্ট কাৰ্যালয়)</label>
                                <input name="post_office" type="text" placeholder="Post Office" class="form-control" id="inputPostOffice" required>
                            </div>
                            <!-- Mobile Number -->
                            <div class="col-md-3">
                                <label for="inputMobileNumber" class="form-label">Mobile Number (ম'বাইল নম্বৰ)</label>
                                <input name="mobile_number" type="text" placeholder="Mobile Number" class="form-control" id="inputMobileNumber" required>
                            </div>
                            <!-- Pin Code -->
                            <div class="col-md-3">
                                <label for="inputPinCode" class="form-label">Pin Code (পিন কোড)</label>
                                <input name="pin_code" type="text" placeholder="Pin Code" class="form-control" id="inputPinCode" required>
                            </div>
                            <!-- Document Uploads -->
                            <div class="col-md-12">
                                <h6>Upload Required Documents (আবশ্যক নথিপত্ৰ আপলোড কৰক)</h6>
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="address_proof" class="form-label">Address Proof (ঠিকনাৰ প্ৰমাণ)</label>
                                        <input name="address_proof" type="file" class="form-control" id="address_proof" required>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="identity_proof" class="form-label">Identity Proof ( পৰিচয় প্ৰমাণ)</label>
                                        <input name="identity_proof" type="file" class="form-control" id="identity_proof" required>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="land_certificate" class="form-label">Land Certificate (মাটিৰ প্ৰমাণ)</label>
                                        <input name="land_certificate" type="file" class="form-control" id="land_certificate" required>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="salary_slip" class="form-label">Salary Slip (বেতন স্লিপ)</label>
                                        <input name="salary_slip" type="file" class="form-control" id="salary_slip" required>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="other_document" class="form-label">Other Document (অন্য নথি)</label>
                                        <input name="other_document" type="file" class="form-control" id="other_document">
                                    </div>
                                    <div class="col-md-4">
                                        <label for="signature" class="form-label">Signature (স্বাক্ষৰ)</label>
                                        <input name="signature" type="file" class="form-control" id="signature" required>
                                    </div>
                                </div>
                            </div>
                            <!-- Submit Button -->
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary">Submit Application</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include('footer.php'); ?>
