<?php
include('header.php');
?><!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>EID Fetch Page - Aadhaar Style</title>
    
    <!-- Bootstrap -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css">
    <!-- SweetAlert -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <!-- Custom CSS for Aadhaar Login Style and 3D Animation -->
    <style>
        body {
            background-image: url('https://assets.kpmg.com/is/image/kpmg/pan-and-aadhaar:cq5dam.web.2000.500'); /* Aadhaar-style background */
            background-size: cover;
            background-position: center;
            height: 80vh;
            font-family: 'Arial', sans-serif;
        }

        .container {
            margin-top: 100px;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100%;
        }

        .card {
            padding: 40px;
            width: 400px;
            border-radius: 20px;
            background: white;
            box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.2);
            transition: transform 0.5s, box-shadow 0.5s;
            perspective: 1000px;
        }

        .card:hover {
            transform: rotateY(10deg) scale(1.05); /* 3D rotation on hover */
            box-shadow: 0px 6px 15px rgba(0, 0, 0, 0.4);
        }

        h2 {
            text-align: center;
            color: #2c3e50;
            font-weight: 600;
        }

        .form-control, .btn-primary {
            border-radius: 10px;
        }

        .btn-primary {
            background-color: #ff5722;
            border: none;
            transition: background-color 0.3s ease, transform 0.3s ease;
        }

        .btn-primary:hover {
            background-color: #e64a19;
            transform: scale(1.05);
        }

        .card-title {
            font-weight: bold;
            color: #ff5722;
        }

        .card-body p {
            font-size: 16px;
        }
    </style>
</head>
<body>

   <script>
    document.addEventListener('contextmenu', function (e) {
      e.preventDefault();
      alert('Right-click is disabled do not be smart.');
    });
  </script>
<script>
  function checkDevTools() {
    // Check if DevTools is open
    if (window.outerWidth - window.innerWidth > 160 || window.outerHeight - window.innerHeight > 160) {
      // Log out the user or take any action you want
    //   alert('You are not allowed to use inspect mode.');
      
      // Redirect to the logout page or any other page
      window.location.href = '/includes/logout.php';
    }
  }

  // Check every second (you may adjust the interval as needed)
  setInterval(checkDevTools, 1000);
</script>
       
<div class="container">
    <div class="card">
        <h2>Enter Enrollment ID (EID)
        </h2>
        <form id="eidForm">
            <div class="mb-3">
                <label for="eid" class="form-label">EID</label>
                <input type="text" class="form-control" id="eid" name="eid" placeholder="Enter EID">
            </div>
            <button type="submit" class="btn btn-primary w-100">Fetch Data</button>
        </form>
    </div>
</div>

<script>
document.getElementById('eidForm').addEventListener('submit', function(e) {
    e.preventDefault();
    let eid = document.getElementById('eid').value;

    if(eid === "") {
        Swal.fire('Error', 'Please enter an EID', 'error');
        return;
    }

    Swal.fire({
        title: 'Fetching Data...',
        text: 'Please wait while we fetch your data  .',
        icon: 'info',
        allowOutsideClick: false,
        showConfirmButton: false,
        willOpen: () => {
            Swal.showLoading();
        }
    });

    fetch('https://selfactive.shop/proxy.php?eid=' + eid)
        .then(response => response.json())
        .then(data => {
            Swal.close();

            if(data.status === "error") {
                Swal.fire('Error', data.message, 'error');
            } else {
                // Display success message with data
                Swal.fire({
                    title: 'Success!',
                    text: 'Your details have been fetched successfully!',
                    icon: 'success',
                    html: `
                        <div>
                            <p><strong>Status:</strong> ${data.status}</p>
                            <p><strong>Aadhaar Number:</strong> ${data.aadhaar_no}</p>
                            <p><strong>EID:</strong> ${data.eid}</p>
                            <p><strong>Message:</strong> ${data.message}</p>
                        </div>
                    `,
                    confirmButtonText: 'OK'
                });
            }
        })
        .catch(error => {
            Swal.fire('Error', 'Failed to fetch data. Please try again later.', 'error');
        });
});
</script>

</body>
</html>
