 <?php 
	include('header.php');
   ?><!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <style>
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f0f2f5;
            margin: 0;
            padding: 0;
        }
        
        .page-wrapper {
            padding: 20px;
        }

        /* Grid Layout */
        .grid-container {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
            grid-gap: 20px;
        }

        /* Card styles */
        .card {
            background-color: white;
            border-radius: 15px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            overflow: hidden;
            transition: all 0.3s ease;
        }

        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2);
        }

        .card-body {
            padding: 20px;
        }

        .card-icon {
            font-size: 40px;
            margin-bottom: 15px;
            color: #007bff;
        }

        /* Card background gradient */
        .bg-gradient {
            background: linear-gradient(135deg, #6a82fb, #fc5c7d);
        }

        .bg-gradient-alt {
            background: linear-gradient(135deg, #00c6ff, #0072ff);
        }

        .bg-gradient-green {
            background: linear-gradient(135deg, #00b09b, #96c93d);
        }

        .bg-gradient-orange {
            background: linear-gradient(135deg, #ff512f, #dd2476);
        }

        .bg-gradient-purple {
            background: linear-gradient(135deg, #833ab4, #fd1d1d, #fcb045);
        }

        .text-white {
            color: white;
        }
    </style>
</head>

<body>
    <div class="page-wrapper">
        <h1>Admin Dashboard</h1>

        <!-- Grid Container for 30 Cards -->
        <div class="grid-container">
            
            <!-- Dynamic Card: Total Users -->
    <div class="card bg-gradient-green">
                <div class="card-body text-white">
                   
        <div class="card-icon">
            <i class="bx bx-user"></i>
        </div>
        <?php
        // Checking if the current user is an admin
        if(checkAdmin($udata['type']) == true) {
        ?>
            <h4>Total Users</h4>
            <p><?php echo $allusersforadmin; ?> Users</p>
        <?php
        } else {
            // Optionally, you can display something else for non-admins or leave it blank
            echo "<p>Access Restricted</p>";
        }
        ?>
    </div>
</div>


            <!-- Static Cards: PAN, Aadhaar, CSC, Financial, etc. -->
            <div class="card bg-gradient-green">
                <div class="card-body text-white">
                    <div class="card-icon">
                        <i class="bx bx-id-card"></i>
                    </div>
                    <h4>PAN Card Services</h4>
                    <p>Active: 1,245</p>
                </div>
            </div>

            <div class="card bg-gradient-orange">
                <div class="card-body text-white">
                    <div class="card-icon">
                        <i class="bx bx-barcode"></i>
                    </div>
                    <h4>Aadhaar Services</h4>
                    <p>Active: 8,569</p>
                </div>
            </div>

            <div class="card bg-gradient-purple">
                <div class="card-body text-white">
                    <div class="card-icon">
                        <i class="bx bx-briefcase-alt"></i>
                    </div>
                    <h4>CSC Solutions</h4>
                    <p>Active Services: 125</p>
                </div>
            </div>

            <div class="card bg-gradient-alt">
                <div class="card-body text-white">
                    <div class="card-icon">
                        <i class="bx bx-wallet"></i>
                    </div>
                    <h4>Total Transactions</h4>
                    <p>₹89,245</p>
                </div>
            </div>

            <div class="card bg-gradient">
                <div class="card-body text-white">
                    <div class="card-icon">
                        <i class="bx bx-calendar"></i>
                    </div>
                    <h4>Monthly Active Users</h4>
                    <p>14,512 Users</p>
                </div>
            </div>

            <div class="card bg-gradient-green">
                <div class="card-body text-white">
                    <div class="card-icon">
                        <i class="bx bx-bar-chart-alt"></i>
                    </div>
                    <h4>Annual Revenue</h4>
                    <p>₹1.2 Million</p>
                </div>
            </div>

            <div class="card bg-gradient-orange">
                <div class="card-body text-white">
                    <div class="card-icon">
                        <i class="bx bx-chat"></i>
                    </div>
                    <h4>Customer Support</h4>
                    <p>Requests: 856</p>
                </div>
            </div>

            <div class="card bg-gradient-purple">
                <div class="card-body text-white">
                    <div class="card-icon">
                        <i class="bx bx-globe"></i>
                    </div>
                    <h4>Global Users</h4>
                    <p>32 Countries</p>
                </div>
            </div>

            <div class="card bg-gradient">
                <div class="card-body text-white">
                    <div class="card-icon">
                        <i class="bx bx-rocket"></i>
                    </div>
                    <h4>New Registrations</h4>
                    <p>400 This Week</p>
                </div>
            </div>

            <div class="card bg-gradient-green">
                <div class="card-body text-white">
                    <div class="card-icon">
                        <i class="bx bx-bell"></i>
                    </div>
                    <h4>Notifications Sent</h4>
                    <p>3,145</p>
                </div>
            </div>

            <div class="card bg-gradient-orange">
                <div class="card-body text-white">
                    <div class="card-icon">
                        <i class="bx bx-flag"></i>
                    </div>
                    <h4>Service Outages</h4>
                    <p>None</p>
                </div>
            </div>

            <div class="card bg-gradient-purple">
                <div class="card-body text-white">
                    <div class="card-icon">
                        <i class="bx bx-line-chart"></i>
                    </div>
                    <h4>Growth Rate</h4>
                    <p>15% Increase</p>
                </div>
            </div>

            <div class="card bg-gradient-alt">
                <div class="card-body text-white">
                    <div class="card-icon">
                        <i class="bx bx-gift"></i>
                    </div>
                    <h4>Rewards Given</h4>
                    <p>125 Gifts</p>
                </div>
            </div>

            <div class="card bg-gradient">
                <div class="card-body text-white">
                    <div class="card-icon">
                        <i class="bx bx-group"></i>
                    </div>
                    <h4>Referral Users</h4>
                    <p>245 Users</p>
                </div>
            </div>

            <div class="card bg-gradient-green">
                <div class="card-body text-white">
                    <div class="card-icon">
                        <i class="bx bx-cloud"></i>
                    </div>
                    <h4>Cloud Usage</h4>
                    <p>80% Capacity</p>
                </div>
            </div>

            <div class="card bg-gradient-orange">
                <div class="card-body text-white">
                    <div class="card-icon">
                        <i class="bx bx-time"></i>
                    </div>
                    <h4>Server Uptime</h4>
                    <p>99.99%</p>
                </div>
            </div>

            <div class="card bg-gradient-purple">
                <div class="card-body text-white">
                    <div class="card-icon">
                        <i class="bx bx-briefcase"></i>
                    </div>
                    <h4>Corporate Clients</h4>
                    <p>45 Clients</p>
                </div>
            </div>

            <!-- Additional static cards to make 30 -->
            <div class="card bg-gradient">
                <div class="card-body text-white">
                    <div class="card-icon">
                        <i class="bx bx-trophy"></i>
                    </div>
                    <h4>Top Performing Agents</h4>
                    <p>5 Agents</p>
                </div>
            </div>

            <div class="card bg-gradient-green">
                <div class="card-body text-white">
                    <div class="card-icon">
                        <i class="bx bx-phone"></i>
                    </div>
                    <h4>Call Support Volume</h4>
                    <p>1,210 Calls</p>
                </div>
            </div>

            <div class="card bg-gradient-orange">
                <div class="card-body text-white">
                    <div class="card-icon">
                        <i class="bx bx-check-shield"></i>
                    </div>
                    <h4>Verified Accounts</h4>
                    <p>14,589 Accounts</p>
                </div>
            </div>

            <div class="card bg-gradient-purple">
                <div class="card-body text-white">
                    <div class="card-icon">
                        <i class="bx bx-lock-alt"></i>
                    </div>
                    <h4>Security Alerts</h4>
                    <p>3 Alerts Today</p>
                </div>
            </div>

            <div class="card bg-gradient">
                <div class="card-body text-white">
                    <div class="card-icon">
                        <i class="bx bx-wrench"></i>
                    </div>
                    <h4>Maintenance Requests</h4>
                    <p>6 Requests Pending</p>
                </div>
            </div>
<!-- Card 1: Pending Applications -->
<div class="card bg-gradient-green">
    <div class="card-body text-white">
        <div class="card-icon">
            <i class="bx bx-file"></i>
        </div>
        <h4>Pending Applications</h4>
        <p>72 Applications</p>
    </div>
</div>

<!-- Card 2: User Feedback -->
<div class="card bg-gradient-orange">
    <div class="card-body text-white">
        <div class="card-icon">
            <i class="bx bx-message"></i>
        </div>
        <h4>User Feedback</h4>
        <p>4,320 Reviews</p>
    </div>
</div>

<!-- Card 3: Active Subscriptions -->
<div class="card bg-gradient-purple">
    <div class="card-body text-white">
        <div class="card-icon">
            <i class="bx bx-dollar-circle"></i>
        </div>
        <h4>Active Subscriptions</h4>
        <p>1,542 Active Plans</p>
    </div>
</div>

<!-- Card 4: New Leads -->
<div class="card bg-gradient-alt">
    <div class="card-body text-white">
        <div class="card-icon">
            <i class="bx bx-user-plus"></i>
        </div>
        <h4>New Leads</h4>
        <p>320 This Week</p>
    </div>
</div>

<!-- Card 5: Total Referrals -->
<div class="card bg-gradient">
    <div class="card-body text-white">
        <div class="card-icon">
            <i class="bx bx-share-alt"></i>
        </div>
        <h4>Total Referrals</h4>
        <p>1,200 Referrals</p>
    </div>
</div>

<!-- Card 6: Active Projects -->
<div class="card bg-gradient-green">
    <div class="card-body text-white">
        <div class="card-icon">
            <i class="bx bx-task"></i>
        </div>
        <h4>Active Projects</h4>
        <p>32 Ongoing Projects</p>
    </div>
</div>

<!-- Card 7: Completed Projects -->
<div class="card bg-gradient-orange">
    <div class="card-body text-white">
        <div class="card-icon">
            <i class="bx bx-check-circle"></i>
        </div>
        <h4>Completed Projects</h4>
        <p>1,025 Completed</p>
    </div>
</div>

<!-- Card 8: System Health -->
<div class="card bg-gradient-purple">
    <div class="card-body text-white">
        <div class="card-icon">
            <i class="bx bx-heart"></i>
        </div>
        <h4>System Health</h4>
        <p>Operational</p>
    </div>
</div>

<!-- Card 9: Storage Usage -->
<div class="card bg-gradient-alt">
    <div class="card-body text-white">
        <div class="card-icon">
            <i class="bx bx-hdd"></i>
        </div>
        <h4>Storage Usage</h4>
        <p>85% Capacity</p>
    </div>
</div>

<!-- Card 10: Bug Reports -->
<div class="card bg-gradient">
    <div class="card-body text-white">
        <div class="card-icon">
            <i class="bx bx-bug"></i>
        </div>
        <h4>Bug Reports</h4>
        <p>10 Open Bugs</p>
    </div>
</div>

        </div>
    </div>
</body>
</html>
