<?php
session_start();
include('../../includes/config.php'); // Include your database configuration

// Step 1: Retrieve the order ID and customer mobile from the session
$order_id = $_SESSION['order_id'] ?? $_GET['order_id'];
$customerMobile = $_SESSION['customer_mobile'] ?? null;

if (!$order_id || !$customerMobile) {
    die('Order ID or customer mobile not found.');
}

// Step 2: Make a POST request to check the order status
$url = 'https://uniquedigitalkendra.xyz/api/check-order-status';
$data = array(
    "order_id" => $order_id,
    "user_token" => "759a55c90857b02f324ddce3b491a094" // Replace with your actual user token
);

$options = array(
    'http' => array(
        'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
        'method'  => 'POST',
        'content' => http_build_query($data),
    ),
);

$context  = stream_context_create($options);
$response = file_get_contents($url, false, $context);

if ($response === FALSE) {
    die('Error occurred while checking the order status');
}

$result = json_decode($response, true);

// Step 3: Handle the API response
if ($result['status'] === true) {
    $txnStatus = $result['result']['txnStatus']; // Transaction status (SUCCESS, PENDING, etc.)
    $txnAmount = $result['result']['amount'];    // Transaction amount

    if ($txnStatus === 'SUCCESS') {
        // Payment was successful, update the wallet
        $sql = "UPDATE usertable SET walletamount = walletamount + ? WHERE phone = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ds", $txnAmount, $customerMobile);

        if ($stmt->execute()) {
            $_SESSION['wallet_updated'][$order_id] = true; // Mark wallet as updated
            echo "<script>
                alert('Payment successful! Wallet updated with ₹$txnAmount.');
                window.location.href = 'https://allservicelive.xyz/admin/wallet.php';
                </script>";
        } else {
            echo "<script>
                alert('Wallet update failed: " . $stmt->error . "');
                window.location.href = 'https://allservicelive.xyz/admin/wallet.php';
                </script>";
        }
        $stmt->close();

    } elseif ($txnStatus === 'PENDING') {
        // Payment is still pending
        echo "<script>
            alert('Payment is pending. Please check back later.');
            window.location.href = 'https://allservicelive.xyz/admin/wallet.php';
            </script>";
    } else {
        // Handle other statuses (e.g., FAILED)
        echo "<script>
            alert('Payment failed or is still pending. Please try again later.');
            window.location.href = 'https://allservicelive.xyz/admin/wallet.php';
            </script>";
    }
} else {
    // Failed API response
    echo "<script>
        alert('Error from API: " . $result['message'] . "');
        window.location.href = 'https://allservicelive.xyz/admin/wallet.php';
        </script>";
}
?>
