<?php
if (!isset($_SESSION)) {
    session_start();
}
include('includes/config.php');

// Function to send OTP via WhatsApp
function sendOtp($phoneNumber, $otp) {
    $apiKey = "Xg4k6YZ07uHXFkSJ7RnoM4RHZdtxan"; // API Key
    $sender = '9580278711'; // Device Number
    $message = "Your OTP for password reset is: $otp";

    $url = "https://whastapp.digitalindiacspbank.com/send-message";
    $data = [
        'api_key' => $apiKey,
        'sender' => $sender,
        'number' => "91{$phoneNumber}",
        'message' => $message
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        return false;
    }
    curl_close($ch);
    return true;
}

// Function to generate a random OTP
function generateOtp($length = 6) {
    return rand(1000, 9999);
}

// Function to send the new password via WhatsApp
function sendWhatsAppReset($phoneNumber, $newPassword) {
    $apiKey = "Xg4k6YZ07uHXFkSJ7RnoM4RHZdtxan"; // API Key
    $sender = '9580278711'; // Device Number
    $message = "Your new password is: $newPassword";

    $url = "https://whastapp.digitalindiacspbank.com/send-message";
    $data = [
        'api_key' => $apiKey,
        'sender' => $sender,
        'number' => "91{$phoneNumber}",
        'message' => $message
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        return false;
    }
    curl_close($ch);
    return true;
}

// Function to generate a new password in the desired format
function generateCustomPassword() {
    $prefix = "UCLANF";
    $randomNumber = rand(1000, 9999); // Generates a random number between 1000 and 9999
    return $prefix . $randomNumber; // Concatenate prefix and random number
}

// Sending OTP logic
if (isset($_POST['send_otp'])) {
    $phoneNumber = mysqli_real_escape_string($conn, $_POST['phone_number']);

    $res = mysqli_query($conn, "SELECT * FROM usertable WHERE phone='$phoneNumber'");
    if (mysqli_num_rows($res) == 1) {
        $otp = generateOtp();
        $_SESSION['otp'] = $otp;
        $_SESSION['phone_number'] = $phoneNumber; // Store phone number for later use
        sendOtp($phoneNumber, $otp);

        ?>
        <script>
        $(function(){
            Swal.fire(
                'OTP Sent!',
                'An OTP has been sent to your phone number.',
                'success'
            ).then(() => {
                $('.otp-container').show(); // Show OTP input form
                $('.forgot-container').hide(); // Hide phone number input form
            });
        });
        </script>
        <?php
    } else {
        ?>
        <script>
        $(function(){
            Swal.fire(
                'Error!',
                'Phone number not found.',
                'error'
            );
        });
        </script>
        <?php
    }
}

// OTP verification logic
if (isset($_POST['verify_otp'])) {
    $inputOtp = $_POST['otp'];
    $phoneNumber = $_SESSION['phone_number'];

    if ($inputOtp == $_SESSION['otp']) {
        $newPassword = generateCustomPassword(); // Generate custom password
        $hashedPassword = password_hash($newPassword, PASSWORD_DEFAULT);

        // Update the new password in the database
        $updateRes = mysqli_query($conn, "UPDATE usertable SET password='$hashedPassword' WHERE phone='$phoneNumber'");

        if ($updateRes) {
            // Send the new password via WhatsApp
            $whatsAppSent = sendWhatsAppReset($phoneNumber, $newPassword);

            if ($whatsAppSent) {
                ?>
                <script>
                $(function(){
                    Swal.fire(
                        'Success!',
                        'A new password has been sent to your WhatsApp.',
                        'success'
                    );
                });
                </script>
                <?php
            } else {
                ?>
                <script>
                $(function(){
                    Swal.fire(
                        'Error!',
                        'Failed to send new password. Please try again.',
                        'error'
                    );
                });
                </script>
                <?php
            }
        } else {
            ?>
            <script>
            $(function(){
                Swal.fire(
                    'Error!',
                    'Failed to update password in the database.',
                    'error'
                );
            });
            </script>
            <?php
        }

        // Clear session data
        unset($_SESSION['otp']);
        unset($_SESSION['phone_number']);
    } else {
        ?>
        <script>
        $(function(){
            Swal.fire(
                'Error!',
                'Incorrect OTP. Please try again.',
                'error'
            );
        });
        </script>
        <?php
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Forgot Password</title>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
        body {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            background-color: #f3f4f6;
            font-family: Arial, sans-serif;
        }
        .container {
            background: white;
            border-radius: 8px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            padding: 20px;
            width: 400px;
            text-align: center;
        }
        .inputBox {
            margin-bottom: 20px;
        }
        .inputBox label {
            display: block;
            margin-bottom: 5px;
        }
        .inputBox input {
            width: 100%;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        input[type="submit"] {
            background: #007bff;
            color: white;
            border: none;
            cursor: pointer;
            border-radius: 4px;
            padding: 10px;
        }
        input[type="submit"]:hover {
            background: #0056b3;
        }
    </style>
</head>
<body>

    <div class="container forgot-container">
        <h2>Forgot Password</h2>
        <form action="" method="POST">
            <div class="inputBox">
                <label for="phone_number">Phone Number</label>
                <input type="text" id="phone_number" name="phone_number" placeholder="Enter your phone number" required>
            </div>
            <input type="submit" name="send_otp" value="Send OTP">
        </form>
    </div>

    <div class="container otp-container" style="display:none;">
        <h2>Enter OTP</h2>
        <form action="" method="POST">
            <div class="inputBox">
                <label for="otp">OTP</label>
                <input type="text" id="otp" name="otp" placeholder="Enter the OTP" required>
            </div>
            <input type="submit" name="verify_otp" value="Verify OTP">
        </form>
    </div>

</body>
</html>
