<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>Mantra RD Service Test</title>
    <style>
        body {
            font-family: 'Segoe UI', Helvetica;
            background-color: #f5f5f5;
        }

        .header {
            padding: 10px;
            text-align: center;
            background-color: #3498db;
            color: white;
        }

        .footer {
            text-align: center;
            padding: 10px;
            margin-top: 20px;
            background-color: #3498db;
            color: white;
        }

        .pageBody {
            padding: 20px;
            text-align: center;
            min-height: 250px;
            margin: 0 auto;
            width: 80%;
            max-width: 600px;
            background-color: white;
            box-shadow: 0px 0px 15px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            border-top: 5px solid #3498db;
        }

        .btnAll {
            color: white;
            background-color: orange;
            padding: 10px 20px;
            border: none;
            cursor: pointer;
            font-weight: bolder;
            border-radius: 5px;
            margin-top: 20px;
        }

        .btnAll:hover {
            background-color: darkorange;
        }

        #divMsg {
            padding: 10px;
            border: 2px dotted #ccc;
            min-height: 50px;
            margin-top: 20px;
            color: green;
            text-align: center;
        }

        .overlay {
            display: none;
            position: fixed;
            top: 0;
            right: 0;
            bottom: 0;
            left: 0;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 1000;
        }

        .loading-text {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            color: white;
            font-size: 20px;
        }

        .loading-text img {
            display: block;
            margin: 10px auto;
            width: 50px;
        }

        select {
            margin-top: 10px;
            padding: 5px;
            font-size: 16px;
            border-radius: 4px;
            border: 1px solid #ddd;
            width: 50%;
        }

        h4 {
            color: #3498db;
        }
    </style>

    <meta name="viewport" content="width=device-width, initial-scale=1">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

    <script language="javascript" type="text/javascript">
        var finalUrl = "";
        var MethodInfo = "";
        var MethodCapture = "";
        var dinfo = "";

        function showLoading(message) {
            document.getElementById("loadingOverlay").style.display = "block";
            document.querySelector(".loading-text").innerHTML = message + '<img src="loading.gif" alt="Loading">';
        }

        function hideLoading() {
            document.getElementById("loadingOverlay").style.display = "none";
        }

        function discoverAvdm() {
            showLoading("Discovering RD service...");

            $("#divMsg").text("");
            $("#ddlAVDM").empty();
            $("#divMsg").text("Discovering ports 8005 and from 11100 to 11120... This will take some time.");

            var primaryUrl = "http://127.0.0.1:";
            var EndFor = 11120;

            var protocol = window.location.href;
            if (protocol.indexOf("https") >= 0) {
                primaryUrl = "https://127.0.0.1:";
                EndFor = 8005;
            }

            for (var i = 8005; i <= EndFor; i++) {
                $.ajax({
                    type: "RDSERVICE",
                    async: false,
                    crossDomain: true,
                    url: primaryUrl + i.toString(),
                    contentType: "text/xml; charset=utf-8",
                    success: function (data) {
                        finalUrl = primaryUrl + i.toString();
                        var $doc = $.parseXML(data);
                        var status = $($doc).find('RDService').attr('status');
                        var info = $($doc).find('RDService').attr('info');

                        if (status === "READY" && info.indexOf("Mantra") >= 0) {
                            dinfo = "1";
                            $("#ddlAVDM").append('<option value="' + i + '">(' + status + ') ' + info + '</option>');
                            discoverAvdmFirstNode(i);
                        }
                    },
                    error: function () {
                        $("#divMsg").append("<div style='color:red;'>RDService not found on port " + i + "</div>");
                    }
                });

                if (i === 8005) {
                    i = 11099;
                }
            }
            hideLoading();
        }

        function discoverAvdmFirstNode(PortNo) {
            var primaryUrl = "http://127.0.0.1:";
            var protocol = window.location.href;
            if (protocol.indexOf("https") >= 0) {
                primaryUrl = "https://127.0.0.1:";
            }

            $.ajax({
                type: "RDSERVICE",
                async: false,
                crossDomain: true,
                url: primaryUrl + PortNo,
                contentType: "text/xml; charset=utf-8",
                success: function (data) {
                    var $doc = $.parseXML(data);
                    MethodInfo = $($doc).find('Interface').eq(0).attr('path');
                    MethodCapture = $($doc).find('Interface').eq(1).attr('path');
                    $("#divMsg").append("<div>Service discovered on port " + PortNo + "</div>");
                },
                error: function () {
                    $("#divMsg").append("<div style='color:red;'>Service discovery failed on port " + PortNo + "</div>");
                }
            });
            deviceInfoAvdm();
        }

        function deviceInfoAvdm() {
            finalUrl = "http://127.0.0.1:" + $("#ddlAVDM").val();
            var protocol = window.location.href;
            if (protocol.indexOf("https") >= 0) {
                finalUrl = "https://127.0.0.1:" + $("#ddlAVDM").val();
            }

            $.ajax({
                type: "DEVICEINFO",
                async: false,
                crossDomain: true,
                url: finalUrl + MethodInfo,
                contentType: "text/xml; charset=utf-8",
                success: function (data) {
                    if (dinfo == "1") {
                        $("#divMsg").append("<div style='color:green;'>Device info retrieved successfully</div>");
                        CaptureAvdm();
                    } else {
                        $("#divMsg").append("<div style='color:red;'>Device info could not be retrieved</div>");
                    }
                },
                error: function () {
                    $("#divMsg").append("<div style='color:red;'>Failed to retrieve device info</div>");
                }
            });
        }

        function CaptureAvdm() {
            var XML = '<?xml version="1.0"?> <PidOptions ver="1.0"> <Opts fCount="1" fType="0" format="0" pidVer="2.0" timeout="10000" /> </PidOptions>';
            $.ajax({
                type: "CAPTURE",
                async: false,
                crossDomain: true,
                url: finalUrl + MethodCapture,
                data: XML,
                contentType: "text/xml; charset=utf-8",
                success: function (data) {
                    var $doc = $.parseXML(data);
                    var Message = $($doc).find('Resp').attr('errInfo');

                    if (Message === "Success") {
                        $("#divMsg").append("<div style='color:green;'>Fingerprint captured successfully</div>");
                    } else {
                        $("#divMsg").append("<div style='color:red;'>Error during capture: " + Message + "</div>");
                    }
                },
                error: function () {
                    $("#divMsg").append("<div style='color:red;'>Failed to capture fingerprint</div>");
                }
            });
        }
    </script>
</head>
<body>
<?phpini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
?>
    <div class="overlay" id="loadingOverlay">
        <div class="loading-text">Loading...</div>
    </div>

    <div class="pageBody">
        <h4>Test Mantra RD Service</h4>
        <p><a href="https://download.mantratecapp.com/Forms/DownLoadFiles">Download RD Service and MFS100 Driver Setup</a></p>

        <input type="button" class="btnAll" value="Start Test" onclick="discoverAvdm();" />

        <select id="ddlAVDM" style="display:none;"></select>

        <div id="divMsg"></div>
    </div>

    <div class="footer">
        <h4>Contact Us</h4>
        <p>For support, email us at <a href="mailto:support@mantratecapp.com">support@mantratecapp.com</a></p>
    </div>

</body>
</html>
