<?php
session_start();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['phone_number'])) {
        // Store phone number in session
        $_SESSION['phone_number'] = $_POST['phone_number'];
        $_SESSION['chat_history'] = [];
    } elseif (isset($_POST['user_message'])) {
        // Get the user's question
        $userMessage = $_POST['user_message'];
        
        // Fetch answer from Google search results
        $botResponse = getGoogleSearchResponse($userMessage);
        
        // Save the conversation in session
        $_SESSION['chat_history'][] = ['user' => $userMessage, 'bot' => $botResponse];
    }
}

function getGoogleSearchResponse($query) {
    $query = urlencode($query);
    $url = "https://www.google.com/search?q=$query";
    
    // Use cURL to fetch the Google search results page
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36");
    $html = curl_exec($ch);
    curl_close($ch);
    
    // Load the HTML into a DOMDocument
    $dom = new DOMDocument;
    @$dom->loadHTML($html);
    
    // Use XPath to query the DOM for the search results
    $xpath = new DOMXPath($dom);
    $nodes = $xpath->query('//div[@class="BNeawe s3v9rd AP7Wnd"]');
    
    if ($nodes->length > 0) {
        // Return the first result snippet
        return $nodes->item(0)->nodeValue;
    } else {
        return "I couldn't find any relevant information. Please try rephrasing your question.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Chatbot</title>
</head>
<body>

<?php if (!isset($_SESSION['phone_number'])): ?>
    <form method="post">
        <label for="phone_number">Enter your phone number:</label>
        <input type="text" id="phone_number" name="phone_number" required>
        <button type="submit">Start Chat</button>
    </form>
<?php else: ?>
    <div>
        <h2>Chat with Bot</h2>
        <div id="chat-history">
            <?php foreach ($_SESSION['chat_history'] as $chat): ?>
                <p><strong>You:</strong> <?= htmlspecialchars($chat['user']) ?></p>
                <p><strong>Bot:</strong> <?= htmlspecialchars($chat['bot']) ?></p>
            <?php endforeach; ?>
        </div>
        <form method="post">
            <input type="text" name="user_message" placeholder="Ask a question..." required>
            <button type="submit">Send</button>
        </form>
    </div>
<?php endif; ?>

</body>
</html>
