<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');


// Check if form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'];
    $status = $_POST['status'];
    
    // Handle file upload
    if (isset($_FILES['admin_file']) && $_FILES['admin_file']['error'] === 0) {
        $file_name = $_FILES['admin_file']['name'];
        $file_tmp = $_FILES['admin_file']['tmp_name'];
        $upload_dir = 'uploads/';
        $file_path = $upload_dir . basename($file_name);
        
        // Move the uploaded file to the 'uploads' directory
        if (move_uploaded_file($file_tmp, $file_path)) {
            // Update status and admin file path in the database
            $sql_update = "UPDATE electoral_roll_applications SET status = '$status', admin_file = '$file_name' WHERE id = '$id'";
            mysqli_query($ahk_conn, $sql_update);
        } else {
            echo "File upload failed.";
        }
    } else {
        // If no file uploaded, only update status
        $sql_update = "UPDATE electoral_roll_applications SET status = '$status' WHERE id = '$id'";
        mysqli_query($ahk_conn, $sql_update);
    }
}

// Fetch applications from the database
$sql = "SELECT * FROM `electoral_roll_applications` ORDER BY id DESC";
$result = mysqli_query($ahk_conn, $sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Electoral Roll Applications Admin Panel</title>
    <link rel="stylesheet" href="path_to_your_css/bootstrap.min.css"> <!-- Bootstrap CSS -->
    <style>
        .card {
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="container mt-5">
        <h2 class="text-center">Electoral Roll Applications Admin Panel</h2>
        <div class="row">
            <?php while ($row = mysqli_fetch_assoc($result)) { ?>
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title"><?= htmlspecialchars($row['applicant_name']) ?></h5>
                            <p><strong>Gender:</strong> <?= htmlspecialchars($row['gender']) ?></p>
                            <p><strong>Mobile Number:</strong> <?= htmlspecialchars($row['mobile_number']) ?></p>
                            <p><strong>Date of Birth:</strong> <?= htmlspecialchars($row['dob']) ?></p>
                            <p><strong>Father's Name:</strong> <?= htmlspecialchars($row['father_name']) ?></p>
                            <p><strong>Aadhaar Number:</strong> <?= htmlspecialchars($row['aadhar_number']) ?></p>
                            <p><strong>PAN Number:</strong> <?= htmlspecialchars($row['pan_number']) ?></p>
                            <p><strong>Email:</strong> <?= htmlspecialchars($row['email_id']) ?></p>
                            <p><strong>State:</strong> <?= htmlspecialchars($row['state']) ?></p>
                            <p><strong>District:</strong> <?= htmlspecialchars($row['district']) ?></p>
                            <p><strong>Sub-Division:</strong> <?= htmlspecialchars($row['sub_division']) ?></p>
                            <p><strong>Circle Office:</strong> <?= htmlspecialchars($row['circle_office']) ?></p>
                            <p><strong>House No:</strong> <?= htmlspecialchars($row['house_no']) ?></p>
                            <p><strong>Mouza:</strong> <?= htmlspecialchars($row['mouza']) ?></p>
                            <p><strong>Village/Town:</strong> <?= htmlspecialchars($row['village_town']) ?></p>
                            <p><strong>Police Station:</strong> <?= htmlspecialchars($row['police_station']) ?></p>
                            <p><strong>Post Office:</strong> <?= htmlspecialchars($row['post_office']) ?></p>
                            <p><strong>PIN Code:</strong> <?= htmlspecialchars($row['pin_code']) ?></p>
                            <p><strong>LAC Name:</strong> <?= htmlspecialchars($row['lac_name']) ?></p>
                            <p><strong>LAC No:</strong> <?= htmlspecialchars($row['lac_no']) ?></p>
                            <p><strong>Polling Station Name:</strong> <?= htmlspecialchars($row['polling_station_name']) ?></p>
                            <p><strong>Polling Station No:</strong> <?= htmlspecialchars($row['polling_station_no']) ?></p>
                            <p><strong>Part Number:</strong> <?= htmlspecialchars($row['part_number']) ?></p>
                            <p><strong>GP/Ward:</strong> <?= htmlspecialchars($row['gp_or_ward']) ?></p>
                            <p><strong>Year of Electoral Roll:</strong> <?= htmlspecialchars($row['year_of_electoral_roll']) ?></p>
                            
                            <p><strong>Registration Number:</strong> <?= htmlspecialchars($row['registration_number']) ?></p>
                            <p><strong>Applied By:</strong> <?= htmlspecialchars($row['applied_by']) ?></p>
                            <p><strong>Balance Deducted:</strong> <?= htmlspecialchars($row['balance_deducted']) ?></p>
                            <p><strong>Application Date:</strong> <?= htmlspecialchars($row['application_date']) ?></p>
                            <p><strong>Status:</strong> <?= htmlspecialchars($row['status']) ?></p>
                            <p>
                                <?php if (!empty($row['voter_id_card'])) { ?>
                                    <a href="uploads/<?= $row['voter_id_card'] ?>" target="_blank"> Download Signature </a>
                                <?php } else { ?>
                                    Land Certificate: No file chosen
                                <?php } ?>
                            </p>
                            <!-- Admin file upload and status update form -->
                            <form action="" method="post" enctype="multipart/form-data">
                                <input type="hidden" name="id" value="<?= $row['id'] ?>">
                                
                                <div class="mb-2">
                                    <label for="admin_file_<?= $row['id'] ?>">Upload Admin File:</label>
                                    <input type="file" name="admin_file" id="admin_file_<?= $row['id'] ?>" class="form-control">
                                </div>
                                
                                <div class="mb-2">
                                    <select name="status" class="form-control">
                                        <option value="approved" <?= ($row['status'] == 'approved') ? 'selected' : '' ?>>Approved</option>
                                        <option value="pending" <?= ($row['status'] == 'pending') ? 'selected' : '' ?>>Pending</option>
                                    </select>
                                </div>
                                
                                <button type="submit" class="btn btn-primary">Update Status</button>
                            </form>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>

    <script src="path_to_your_js/bootstrap.min.js"></script> <!-- Bootstrap JS -->
</body>
</html>
