

<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

// Check if form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'];
    $status = $_POST['status'];
    
    // Handle file upload
    if (isset($_FILES['admin_file']) && $_FILES['admin_file']['error'] === 0) {
        $file_name = $_FILES['admin_file']['name'];
        $file_tmp = $_FILES['admin_file']['tmp_name'];
        $upload_dir = 'uploads/';
        $file_path = $upload_dir . basename($file_name);
        
        // Move the uploaded file to the 'uploads' directory
        if (move_uploaded_file($file_tmp, $file_path)) {
            // Update status and admin file path in the database
            $sql_update = "UPDATE birtdelay_certificates SET status = '$status', admin_file = '$file_name' WHERE id = '$id'";
            mysqli_query($ahk_conn, $sql_update);
        } else {
            echo "File upload failed.";
        }
    } else {
        // If no file uploaded, only update status
        $sql_update = "UPDATE birtdelay_certificates SET status = '$status' WHERE id = '$id'";
        mysqli_query($ahk_conn, $sql_update);
    }
}

// Fetch kin certificates from the database
$sql = "SELECT * FROM `birtdelay_certificates` ORDER BY id DESC";
$result = mysqli_query($ahk_conn, $sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin - Birth Delay Certificates</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .certificate-container {
            border: 2px solid #007bff;
            border-radius: 15px;
            padding: 20px;
            background-color: #ffffff;
            margin-bottom: 30px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        h2 {
            color: #007bff;
            text-align: center;
            margin-bottom: 20px;
        }
        .footer {
            text-align: center;
            margin-top: 20px;
            font-size: 12px;
            color: #666;
        }
    </style>
</head>
<body>
<div class="container mt-5">
    <h2>Birth Delay Certificates Management</h2>
    <?php if ($result->num_rows > 0): ?>
        <?php while ($row = $result->fetch_assoc()): ?>
            <div class="certificate-container">
                <h5 class="card-title"><?= htmlspecialchars($row['applicant_name']) ?>'s Birth Delay Certificate</h5>
                <p><strong>Certificate ID:</strong> <?= htmlspecialchars($row['id']) ?></p>
                <p><strong>Relationship:</strong> <?= htmlspecialchars($row['relationship']) ?></p>
                <p><strong>Date of Birth:</strong> <?= date('d-m-Y', strtotime($row['dob'])) ?></p>
                <p><strong>Mother's Name:</strong> <?= htmlspecialchars($row['mother_name']) ?></p>
                <p><strong>Father's Name:</strong> <?= htmlspecialchars($row['father_name']) ?></p>
                <p><strong>Gender:</strong> <?= htmlspecialchars($row['gender']) ?></p>
                <p><strong>Place of Birth:</strong> <?= htmlspecialchars($row['place_of_birth']) ?></p>
                <p><strong>Name of Hospital:</strong> <?= htmlspecialchars($row['hospital_name']) ?></p>
                <p><strong>Address:</strong> <?= htmlspecialchars($row['address']) ?></p>
                <p><strong>Reason for Delay:</strong> <?= htmlspecialchars($row['reason_for_delay']) ?></p>
                <p><strong>Relation with Deceased:</strong> <?= htmlspecialchars($row['relation_with_deceased']) ?></p>
                <p><strong>State:</strong> <?= htmlspecialchars($row['state']) ?></p>
                <p><strong>District:</strong> <?= htmlspecialchars($row['district']) ?></p>
                <p><strong>Subdivision:</strong> <?= htmlspecialchars($row['subdivision']) ?></p>
                <p><strong>Circle Office:</strong> <?= htmlspecialchars($row['circle_office']) ?></p>
                <p><strong>Village/Town:</strong> <?= htmlspecialchars($row['village_town']) ?></p>
                <p><strong>Police Station:</strong> <?= htmlspecialchars($row['police_station']) ?></p>
                <p><strong>Post Office:</strong> <?= htmlspecialchars($row['post_office']) ?></p>
                <p><strong>Mobile Number:</strong> <?= htmlspecialchars($row['mobile_number']) ?></p>
                <p><strong>Created At:</strong> <?= date('d-m-Y H:i:s', strtotime($row['created_at'])) ?></p>
            </div>
        <?php endwhile; ?>
    <?php else: ?>
        <div class="alert alert-warning">No records found.</div>
    <?php endif; ?>
    <div class="footer">
        <p>&copy; <?php echo date("Y"); ?> Birth Delay Certificate Management System</p>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
