<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Instant Balance Add By Axen Payment Gateway</title>
    <!-- Include jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <!-- Include SweetAlert -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.4.14/dist/sweetalert2.all.min.js"></script>
</head>
<body>

<?php
session_start();

$hostname = 'localhost';
$username = 'pushpap2_print'; // Replace and fill your database name here.
$password = 'pushpap2_print'; // Replace and fill your database Password here.
$database = 'pushpap2_print'; // Replace and fill your database .

$conn = new mysqli($hostname, $username, $password, $database);

if ($conn->connect_error) {
    echo "<script>alert('Database connection failed: " . $conn->connect_error . "');</script>";
    die();
}

if (isset($_SESSION['order_id']) && isset($_SESSION['customer_mobile'])) {
    $order_id = $_SESSION['order_id'];
    $customer_mobile = $_SESSION['customer_mobile'];

    if (!isset($_SESSION['wallet_updated'][$order_id])) {
        $url = "https://axenpayment.com/api/check-order-status";

        $postData = array(
            "user_token" => "a35b65b4da16ac67ae7eef61b256915e",  // API Token
            "order_id" => $order_id
        );

        $ch = curl_init($url);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));

        $response = curl_exec($ch);

        if ($response === false) {
            $curlError = curl_error($ch);
            echo "<script>alert('cURL Error: " . $curlError . "');</script>";
            curl_close($ch);
            exit;
        }

        curl_close($ch);

        $responseData = json_decode($response, true);

        if ($responseData["status"] === "COMPLETED" && $responseData["result"]["txnStatus"] === "COMPLETED") {
            $amount = $responseData["result"]["amount"];
            echo "PAYMENT SUCCESSFUL";

            $stmt = $conn->prepare("UPDATE usertable SET walletamount = walletamount + ? WHERE phone = ?");
            $stmt->bind_param("is", $amount, $customer_mobile); // i for integer, s for string

            if ($stmt->execute()) {
                $_SESSION['wallet_updated'][$order_id] = true; // Mark wallet as updated
                echo "<script>
                    Swal.fire({
                        title: 'SUCCESS',
                        text: 'WALLET UPDATED SUCCESSFULLY',
                        icon: 'success',
                        confirmButtonText: 'OK'
                    }).then(function() {
                        window.location.href = 'https://".$_SERVER['SERVER_NAME']."/admin/index.php'; 
                    });
                </script>";
            } else {
                echo "<script>
                    Swal.fire({
                        title: 'WALLET UPDATE FAILED',
                        text: 'Update failed: " . $conn->error . "',
                        icon: 'error',
                        confirmButtonText: 'OK'
                    }).then(function() {
                        window.location.href = 'https://".$_SERVER['SERVER_NAME']."/admin/index.php';
                    });
                </script>";
            }

            $stmt->close();
        } else {
            echo "<script>
                Swal.fire({
                    title: 'Please Contect Support',
                    text: 'Sorry, I couldn't update the wallet.. Status: " . ($responseData["status"] ?? "Unknown") . "',
                    icon: 'error',
                    confirmButtonText: 'OK'
                }).then(function() {
                    window.location.href = 'https://".$_SERVER['SERVER_NAME']."/admin/index.php';
                });
            </script>";
        }
    } else {
        echo "<script>
            Swal.fire({
                title: 'Do not repeat the same order. Wallet already updated.',
                text: 'Wallet already updated for this order ID',
                icon: 'info',
                confirmButtonText: 'OK'
            }).then(function() {
                window.location.href = 'https://".$_SERVER['SERVER_NAME']."/admin/index.php';
            });
        </script>";
    }
} else {
    echo "<script>Swal.fire('Error', 'Order ID or Customer Mobile not set in session', 'error');</script>";
}
?>

</body>
</html>
