<?php
session_start(); // Start the session to store OTP

require_once 'vendor/autoload.php'; // Include the Twilio PHP SDK

use Twilio\Rest\Client;

// Twilio credentials
$sid    = "AC712f171bc8c0c31d823a1a8b08f7855c";
$token  = "643a4b5b8ff6b7c9736055956708d880";
$twilio = new Client($sid, $token);

// Initialize variables
$otpSent = false;
$otpVerified = false;

// Handle OTP sending
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['send_otp'])) {
    $phone = $_POST['phone'];

    // Generate a random 6-digit OTP
    $otp = mt_rand(100000, 999999);

    // Message to be sent
    $messageBody = "Your OTP is: " . $otp;

    try {
        // Send the OTP via SMS
        $twilio->messages->create(
            $phone,
            [
                "body" => $messageBody,
                "from" => "+14432017488" // Your Twilio phone number
            ]
        );

        // Save OTP and phone number in session
        $_SESSION['otp'] = $otp;
        $_SESSION['phone'] = $phone;

        $otpSent = true;
    } catch (Exception $e) {
        echo "Error: " . $e->getMessage();
    }
}

// Handle OTP verification
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['verify_otp'])) {
    $userOtp = $_POST['otp'];

    // Compare entered OTP with the OTP stored in session
    if ($userOtp == $_SESSION['otp']) {
        $otpVerified = true;
        // Redirect to success page
        header("Location: success.php");
        exit();
    } else {
        echo "Invalid OTP. Please try again.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>OTP Verification</title>
</head>
<body>
    <h2>Send OTP</h2>
    <?php if (!$otpSent && !$otpVerified): ?>
        <form action="index.php" method="POST">
            <label for="phone">Phone Number:</label><br>
            <input type="text" id="phone" name="phone" required><br><br>
            <input type="submit" name="send_otp" value="Send OTP">
        </form>
    <?php endif; ?>

    <?php if ($otpSent && !$otpVerified): ?>
        <h2>Verify OTP</h2>
        <form action="index.php" method="POST">
            <label for="otp">Enter OTP:</label><br>
            <input type="text" id="otp" name="otp" required><br><br>
            <input type="submit" name="verify_otp" value="Verify OTP">
        </form>
    <?php elseif ($otpVerified): ?>
        <h2>Success!</h2>
        <p>Your OTP has been verified successfully.</p>
    <?php endif; ?>
</body>
</html>
